/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server.forward;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IStep;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.script.JdbcScriptCtrl;
import com.harrand.dbwrench.script.builder.DatabaseScriptBuilder;
import com.harrand.dbwrench.script.svrSync.ISvrSyncCtrl;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.worker.meta.RevEngWorker;
import com.harrand.dbwrenchnb.server.forward.IScriptClient;
import com.harrand.util.FileHelper;
import javax.swing.JButton;

public class ForEngCtrl
implements IObservable,
IObserver,
IThreadObserver {
    private static ForEngCtrl instance__ = new ForEngCtrl();
    private JdbcConfig config;
    private Database designDb;
    private String truncationWarning_;
    private BasicObservable observable_ = new BasicObservable();
    private int tableCount_ = 0;
    private int fkCount_ = 0;
    private int procCount_ = 0;
    private String statusMsg_ = "";
    private IMetaDataCtrl metaDataCtrlOverall_;
    private ITestResult recalcResult_;
    private JButton disabledBtn;
    private IStatusDisplayer statusDisplayer;
    private IScriptClient scriptClient;
    public static final String INCOMPLETE_RESULT = "Incomplete Result";
    public static final String SCRIPT_GENERATED = "Script Generated";
    public static final String SCRIPT_GENERATION_FAILED = "Script Generation Failed";
    private boolean doRevSync;

    private ForEngCtrl() {
    }

    public static ForEngCtrl getInstance() {
        return instance__;
    }

    public ITestResult getRecalculateResult() {
        return this.recalcResult_;
    }

    public void setDisabledButton(JButton btn) {
        this.disabledBtn = btn;
    }

    public void setStatusDisplayer(IStatusDisplayer statusDisplayer) {
        this.statusDisplayer = statusDisplayer;
    }

    public void startRecalculate(JdbcConfig config, IScriptClient scriptClient, Database designDb) {
        this.setConfig(config);
        this.setDesignDb(designDb);
        this.scriptClient = scriptClient;
        this.recalcResult_ = new DataEntryResult(true, INCOMPLETE_RESULT, "ForEngCtrl.recalc just started");
        Database productionDb = null;
        if (config.isGeneric()) {
            productionDb = new Database(designDb.getName());
            IScript script = this.buildScript(productionDb, "ForEngCtrl.recalced generic script");
            scriptClient.setForEngScript(script);
        } else {
            this.startRevEng();
        }
    }

    private IScript buildScript(Database productionDb, String scriptTypeMsg) {
        IScript script = DatabaseScriptBuilder.getEmptyScript();
        DatabaseScriptBuilder builder = this.getScriptBldr();
        script = (IScript)builder.getStep(productionDb, this.designDb);
        this.recalcResult_ = new DataEntryResult(true, SCRIPT_GENERATED, scriptTypeMsg);
        return script;
    }

    public String getBackupWarningStr(JdbcConfig config, IScript script, String dbNm) {
        this.setConfig(config);
        String backupMsg = App.getRes("engineer.forward.backup.data.msg");
        String msg = App.getRes("engineer.forward.confirm.msg");
        String dbLabel = App.getRes("database.label");
        String serverLabel = FileHelper.getRes("server.label");
        JdbcScriptCtrl scriptCtrl = new JdbcScriptCtrl();
        String dataLossStr = scriptCtrl.getDataLossWarning(script);
        String dataTruncationWarning = this.getDataTruncationWarning();
        StringBuffer sb = new StringBuffer(backupMsg + "\n");
        if (dataLossStr.length() > 0) {
            sb.append("\n" + dataLossStr);
        }
        if (dataTruncationWarning != null) {
            sb.append("\n" + dataTruncationWarning + "\n");
        }
        sb.append("\n" + msg + "? \n");
        sb.append("(" + dbLabel + ": " + dbNm + ",     ");
        sb.append(serverLabel + ": " + this.config.getServer() + ")");
        return sb.toString();
    }

    public String getDataTruncationWarning() {
        return this.truncationWarning_;
    }

    public String getStatusMsg() {
        return this.statusMsg_;
    }

    private void setConfig(JdbcConfig config) {
        this.config = config;
    }

    private void setDesignDb(Database db) {
        this.designDb = db;
    }

    private DatabaseScriptBuilder getScriptBldr() {
        DatabaseScriptBuilder builder = new DatabaseScriptBuilder(this.config);
        DbUser user = App.getUser();
        IOptionMgr forEngOptionMgr = user.getOptionMgr("forward.engineer.option.mgr");
        builder.setForEngOptMgr(forEngOptionMgr);
        builder.setAllowTableDrop(true);
        return builder;
    }

    private void resetCounters() {
        this.tableCount_ = 0;
        this.fkCount_ = 0;
        this.procCount_ = 0;
    }

    private void startRevEng() {
        IMetaDataCtrl metaDataCtrl;
        this.metaDataCtrlOverall_ = metaDataCtrl = this.config.getMetaDataCtrl();
        this.metaDataCtrlOverall_.addObserver(this);
        this.resetCounters();
        RevEngWorker revEngWorker = new RevEngWorker();
        revEngWorker.setForRevSync(false);
        revEngWorker.setDisabledButton(this.disabledBtn);
        revEngWorker.setStatusDisplayer(this.statusDisplayer);
        revEngWorker.startRevEng(this.config, this.metaDataCtrlOverall_, this);
    }

    public ITestResult getWasExecuted(IStep step) {
        boolean stepExec = step.getWasExecuted();
        DataEntryResult result = stepExec ? new DataEntryResult(true, "Warning - Script Previously Executed", "This script has already been executed.\nAre you sure you want to execute it again?") : new DataEntryResult(false, "Script not been executed", "Script not been executed");
        return result;
    }

    public void checkDbSynced(JdbcConfig config, Database designDb) {
        ISvrSyncCtrl svrSyncCtrl = config.getSvrSyncCtrl();
        if (svrSyncCtrl != null) {
            this.statusMsg_ = "Checking for automatically created objects...";
            this.notifyObservers(null);
            RevEngWorker revEngWorker = new RevEngWorker();
            revEngWorker.setForRevSync(false);
            this.doRevSync = true;
            revEngWorker.setDisabledButton(this.disabledBtn);
            revEngWorker.setStatusDisplayer(this.statusDisplayer);
            revEngWorker.startRevEng(config, this.metaDataCtrlOverall_, this);
        }
    }

    private void buildScript(Database revEngDb) {
        IScript script = DatabaseScriptBuilder.getEmptyScript();
        if (revEngDb != null) {
            script = this.buildScript(revEngDb, "ForEngCtrl.recalced script");
        }
        this.scriptClient.setForEngScript(script);
    }

    private void syncAutoCreatedItems(Database revEngDb) {
        ISvrSyncCtrl svrSyncCtrl = this.config.getSvrSyncCtrl();
        svrSyncCtrl.setSvrDb(revEngDb);
        svrSyncCtrl.syncAll(this.designDb);
        this.statusMsg_ = StrHelper.READY_STR;
        this.notifyObservers(null);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IMetaDataCtrl.class.getName())) {
            this.updateRevEngStatus();
        }
    }

    private void updateRevEngStatus() {
        String mileStone = this.metaDataCtrlOverall_.getMilestoneDesc();
        String prefix = "Analyzing Server Database: Analyzed ";
        this.statusMsg_ = "";
        boolean refresh = false;
        if (mileStone == null) {
            return;
        }
        if (mileStone.indexOf("Added table") >= 0) {
            ++this.tableCount_;
            this.statusMsg_ = prefix + this.tableCount_ + " tables...";
            refresh = true;
        }
        if (mileStone.indexOf("Added foreign key") >= 0) {
            ++this.fkCount_;
            this.statusMsg_ = prefix + this.fkCount_ + " foreign keys...";
            refresh = true;
        }
        if (mileStone.indexOf("Added Proc") >= 0) {
            ++this.procCount_;
            this.statusMsg_ = prefix + this.procCount_ + " procedures...";
            refresh = true;
        }
        if (refresh) {
            this.notifyObservers(null);
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        RevEngWorker worker = (RevEngWorker)threadWorker;
        Database revEngDb = worker.getRevEngDb();
        if (this.doRevSync) {
            this.syncAutoCreatedItems(revEngDb);
            this.doRevSync = false;
        } else {
            this.buildScript(revEngDb);
        }
    }
}

