/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server.display;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.status.ClockPanel;
import com.harrand.coregui.display.status.FadingTextPanel;
import com.harrand.coregui.display.status.IStatusDisplayer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class FadingStatusPanel
extends JPanel
implements IStatusDisplayer,
IObserver {
    private ClockPanel clockPanel = new ClockPanel();
    private FadingTextPanel messagePanel = new FadingTextPanel();
    private String statusMsg = "";
    private final int startX;

    public FadingStatusPanel(int startX) {
        this.startX = startX;
        this.clockPanel.setElapsedTimeObserver(this);
        this.init();
    }

    private void init() {
        this.setupGui();
    }

    private void setupGui() {
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalStrut(this.startX));
        this.add(this.clockPanel);
        this.add(Box.createHorizontalStrut(4));
        this.add(this.messagePanel);
        this.add(Box.createHorizontalGlue());
    }

    @Override
    public void startAnimation() {
        this.clockPanel.start();
    }

    @Override
    public void stopAnimation() {
        this.clockPanel.stop();
        this.messagePanel.startWait();
    }

    @Override
    public void setStatusMsg(String msg) {
        this.statusMsg = msg;
        this.updateDisplay();
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateDisplay();
    }

    private void updateDisplay() {
        String elapsedStr = this.clockPanel.getElapsedStr();
        this.messagePanel.setText(elapsedStr + " " + this.statusMsg);
    }
}

