/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.server.conn;

import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.db.JdbcHelper;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnCheckerWorker
extends SwingWorker<Boolean, Void> {
    private IThreadObserver threadObserver;
    private String testMsg = FileHelper.getResource("test.status.passed");
    private JdbcConfig cfg;

    @Override
    protected Boolean doInBackground() throws Exception {
        Boolean validObj = true;
        try {
            Connection conn = ConnectionFactory.getConnection(this.cfg);
            ConnectionFactory.close(conn);
        }
        catch (SQLException ex) {
            this.testMsg = JdbcHelper.cleanMySqlConnErrMsg(ex.getMessage());
            GuiMessageHelper.showGeneralAppErrMsg(null, this.testMsg);
            validObj = false;
        }
        return validObj;
    }

    @Override
    protected void done() {
        super.done();
        this.threadObserver.threadDone(this);
    }

    public void startCheck(JdbcConfig cfg, IThreadObserver threadObserver) {
        this.cfg = cfg;
        this.threadObserver = threadObserver;
        try {
            this.execute();
        }
        catch (Exception ex) {
            String errMsg = "RevEngWorker threw an exception: \n" + ex.getMessage();
            LogUtil.logErr(errMsg);
        }
    }
}

