/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.panel.status;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchnb.lifecycle.SetDb;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.awt.StatusLineElementProvider;

public class DesignFileStatusPanel
extends JPanel
implements StatusLineElementProvider,
IObserver {
    private static DesignFileStatusPanel instance__;
    private JLabel lblInfo_ = new JLabel("<no database open>");
    private CentralLookup centralLookup_ = CentralLookup.getDefault();
    private Database db_;
    private boolean dirty_;

    public DesignFileStatusPanel() {
        this.layoutPanel();
        this.setCosmetics();
        this.centralLookup_.addObserver(this);
        this.checkDbChanged();
        instance__ = this;
    }

    public Component getStatusLineElement() {
        return this;
    }

    public static DesignFileStatusPanel getInstance() {
        return instance__;
    }

    public void setText(String text) {
        this.lblInfo_.setText(" |    " + text);
    }

    public void setDirty(boolean dirty) {
        this.dirty_ = dirty;
        this.refresh();
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblInfo_, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 10));
    }

    private void checkDbChanged() {
        Database newDb = this.getLookupDb();
        if (LookupUtil.isNewDbSet(this.db_, newDb)) {
            this.db_ = newDb;
            this.refresh();
        }
    }

    private Database getLookupDb() {
        return (Database)this.centralLookup_.lookup(Database.class);
    }

    @Override
    public void update(UpdateChain chain) {
        if (LookupUtil.isDbLookupUpdate(chain)) {
            this.checkDbChanged();
        }
    }

    private void refresh() {
        StringBuffer sb = new StringBuffer("No Database Open");
        boolean dirty = SetDb.getInstance().getDirty();
        if (this.db_ != null) {
            sb = new StringBuffer(this.db_.getDisplayTitle());
            if (dirty) {
                sb.append("*");
            }
        }
        this.setText(sb.toString());
    }

    private void setCosmetics() {
    }
}

