/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.nb;

import com.harrand.dbwrenchnb.nb.NbUtil;
import java.util.ArrayList;
import java.util.List;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class NodeExpansionMgr {
    private List<String> expandedPaths_ = new ArrayList<String>();
    private TreeView treeView_;
    private String lastSelectedNodePath_;
    public static final String PATH_DELIM = "/";

    public NodeExpansionMgr(TreeView treeView) {
        this.treeView_ = treeView;
    }

    public List<String> getExpandedPaths(Node rootCtx) {
        this.storeExpanded(rootCtx);
        return this.expandedPaths_;
    }

    public void storeExpanded(Node rootContext) {
        this.expandedPaths_ = new ArrayList<String>();
        this.checkExpanded(rootContext, rootContext.getName());
    }

    public void setExpandedPaths(List<String> paths) {
        this.expandedPaths_ = paths != null ? paths : new ArrayList<String>();
    }

    public void expandNodes(Node rootContext) {
        this.expandIfStored(rootContext, rootContext.getName());
    }

    public void storeLastSelectedPath(Node selectedNode) {
        this.lastSelectedNodePath_ = null;
        if (selectedNode != null) {
            this.lastSelectedNodePath_ = NbUtil.getNodePath(selectedNode);
        }
    }

    public void selectLastSelectedNode(ExplorerManager expMgr) {
        Node matchingNode;
        if (this.lastSelectedNodePath_ != null && (matchingNode = NbUtil.getNodeFromPath(expMgr, this.lastSelectedNodePath_)) != null) {
            NbUtil.selectNode(expMgr, matchingNode);
        }
    }

    private void checkExpanded(Node node, String path) {
        if (this.treeView_.isExpanded(node)) {
            this.expandedPaths_.add(path);
        }
        Node[] childNodes = node.getChildren().getNodes();
        for (int i = 0; i < childNodes.length; ++i) {
            Node childNode = childNodes[i];
            String idStr = childNode.getDisplayName();
            String childPath = path + PATH_DELIM + idStr;
            this.checkExpanded(childNode, childPath);
        }
    }

    private void expandIfStored(Node node, String path) {
        if (this.expandedPaths_.contains(path)) {
            this.treeView_.expandNode(node);
        }
        Node[] childNodes = node.getChildren().getNodes();
        for (int i = 0; i < childNodes.length; ++i) {
            Node childNode = childNodes[i];
            String idStr = childNode.getDisplayName();
            String childPath = path + PATH_DELIM + idStr;
            this.expandIfStored(childNode, childPath);
        }
    }
}

