/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.nb;

import com.harrand.coreclasses.element.ISelectable;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.dbwrenchnb.diagram.DiagramTC;
import com.harrand.dbwrenchnb.editor.EditorTC;
import com.harrand.util.LogUtil;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class NbUtil {
    public static final String DBW_LOG_NM = "DbWrench Log";

    public static void logMsg(String msg) {
        InputOutput io = IOProvider.getDefault().getIO(DBW_LOG_NM, false);
        io.getOut().println(msg);
        io.getOut().close();
    }

    public static String getFolderClosedImgPath() {
        return "com/harrand/coregui/images/FileClosedEc16.gif";
    }

    public static void viewLookup(Lookup lookup, String msg) {
        NbUtil.logMsg("============= NbUtil.Lookup: " + msg + " =================");
        Collection objs = lookup.lookupResult(Object.class).allInstances();
        for (Object obj : objs) {
            NbUtil.logMsg("NbUtil.obj: " + obj);
        }
    }

    public static void listOpenWindows() {
        NbUtil.logMsg("=============== NbUtil.Open TCs ================");
        Set comps = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : comps) {
            NbUtil.logMsg("NbUtil.tc.class/displayName: " + tc.getClass() + "/" + tc.getDisplayName());
        }
    }

    public static void setTitleBarText(final String title) {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
                frame.setTitle(title);
            }
        });
    }

    public static String getTitleBarText() {
        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
        return frame.getTitle();
    }

    public static Set<TopComponent> getOpenWindows() {
        return TopComponent.getRegistry().getOpened();
    }

    public static TopComponent getShowingTcInMode(String modeNm) {
        Set modes = WindowManager.getDefault().getModes();
        TopComponent showingTc = null;
        for (Mode mode : modes) {
            TopComponent[] tcs;
            if (!mode.getName().equals(modeNm)) continue;
            for (TopComponent tc : tcs = mode.getTopComponents()) {
                if (!tc.isShowing() || !((showingTc = tc) instanceof ISelectable) || !((ISelectable)showingTc).getSelected()) continue;
                return showingTc;
            }
        }
        return showingTc;
    }

    public static void closeEditors() {
        ArrayList<TopComponent> toClose = new ArrayList<TopComponent>();
        Set comps = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : comps) {
            boolean isDiagramTC = tc instanceof DiagramTC;
            boolean isEditorTC = tc instanceof EditorTC;
            if (!isDiagramTC && !isEditorTC) continue;
            toClose.add(tc);
        }
        for (TopComponent tc : toClose) {
            tc.close();
        }
    }

    public static String getNodePath(Node node) {
        StringBuffer sb = new StringBuffer(node.getDisplayName());
        Node parentNode = node.getParentNode();
        while (parentNode != null) {
            Node newParent;
            sb.insert(0, "/");
            sb.insert(0, parentNode.getDisplayName());
            parentNode = newParent = parentNode.getParentNode();
        }
        return sb.toString();
    }

    public static Node getNodeFromPath(ExplorerManager expMgr, String path) {
        Node foundNode = null;
        ArrayList<Node> allNodes = new ArrayList<Node>();
        NbUtil.addAllChildNodes(expMgr.getRootContext(), allNodes);
        for (Node node : allNodes) {
            String nodePath = NbUtil.getNodePath(node);
            if (!path.equals(nodePath)) continue;
            foundNode = node;
        }
        return foundNode;
    }

    public static void addAllChildNodes(Node node, List<Node> nodes) {
        nodes.add(node);
        Node[] childNodes = node.getChildren().getNodes();
        for (int i = 0; i < childNodes.length; ++i) {
            Node childNode = childNodes[i];
            NbUtil.addAllChildNodes(childNode, nodes);
        }
    }

    public static void selectNode(ExplorerManager expMgr, Node node) {
        Node[] nodes = new Node[]{node};
        try {
            expMgr.setSelectedNodes(nodes);
        }
        catch (PropertyVetoException ex) {
            LogUtil.logErr("NodeExpansionMgr.selectLastSelectedNode().err: " + ex.getMessage());
        }
    }

    private static TopComponent findTopComponent(String preferredId) {
        TopComponent tc = WindowManager.getDefault().findTopComponent(preferredId);
        if (tc == null) {
            LogUtil.logErr("NbUtil: Could not find top component: " + preferredId);
        }
        return tc;
    }

    public static TopComponent activateOpenTopComponent(String preferredId) {
        TopComponent tc = NbUtil.findTopComponent(preferredId);
        if (tc != null) {
            if (tc.isOpened()) {
                tc.requestActive();
            } else {
                return null;
            }
        }
        return tc;
    }

    public static TopComponent openActivateTc(String preferredId) {
        TopComponent tc = NbUtil.findTopComponent(preferredId);
        if (tc != null) {
            if (!tc.isOpened()) {
                tc.open();
            }
            tc.requestActive();
        }
        return tc;
    }

    public static TopComponent findTopComponent(String classNm, String displayNm) {
        ArrayList comps = new ArrayList(TopComponent.getRegistry().getOpened());
        int size = comps.size();
        TopComponent tcFound = null;
        for (int i = 0; tcFound == null && i < size; ++i) {
            TopComponent tc = (TopComponent)comps.get(i);
            String tcClassNm = tc.getClass().getName();
            if (!tcClassNm.equalsIgnoreCase(classNm)) continue;
            if (displayNm != null) {
                if (!StrHelper.getMatchesAsteriskable(tc.getDisplayName(), displayNm)) continue;
                tcFound = tc;
                continue;
            }
            tcFound = tc;
        }
        return tcFound;
    }

    public static TopComponent findShowingSelectedTC(String classNm) {
        TopComponent foundTC = null;
        for (TopComponent tc : NbUtil.getTCsByClass(classNm)) {
            ISelectable selectable;
            if (!tc.isShowing()) continue;
            if (foundTC == null) {
                foundTC = tc;
            }
            if (!(tc instanceof ISelectable) || !(selectable = (ISelectable)tc).getSelected()) continue;
            foundTC = tc;
        }
        return foundTC;
    }

    private static List<TopComponent> getTCsByClass(String classNm) {
        ArrayList<TopComponent> matchingTCs = new ArrayList<TopComponent>();
        Set allTCs = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : allTCs) {
            String tcClassNm = tc.getClass().getName();
            if (!tcClassNm.equalsIgnoreCase(classNm)) continue;
            matchingTCs.add(tc);
        }
        return matchingTCs;
    }
}

