/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.menu;

import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchnb.action.db.LoadDb;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.awt.DynamicMenuContent;

public class RecentFilesMenu
extends JMenu
implements DynamicMenuContent,
IObserver {
    private static RecentFilesMenu instance__ = new RecentFilesMenu();
    private IFileUseMgr fileUseMgr_;
    private final String DB_KEY;
    private final int MAX_FILES = 10;
    public static final String TEXT = "Open Recent File";

    private RecentFilesMenu() {
        super(TEXT);
        App.getFileUseMgr();
        this.DB_KEY = "Database";
        this.MAX_FILES = 10;
        this.setMnemonic(70);
        this.refreshMenu();
    }

    public static RecentFilesMenu getInstance() {
        return instance__;
    }

    public void setFileUseMgr(IFileUseMgr fileUseMgr) {
        this.fileUseMgr_ = fileUseMgr;
        ((IObservable)((Object)this.fileUseMgr_)).addObserver(this);
    }

    private void refreshMenu() {
        this.removeAll();
        int i = 0;
        if (this.fileUseMgr_ != null) {
            List recentFiles = this.fileUseMgr_.getRecentFiles(this.DB_KEY);
            for (File file : recentFiles) {
                String absolutePath = file.getAbsolutePath();
                this.addMenuItem(absolutePath, i++);
                if (i <= 10) continue;
                break;
            }
        } else {
            String path = "C:\\Software\\Dbw\\dbwrenchgui\\userData\\databases\\";
            this.addMenuItem(path + "bpsimple.xml", i++);
            this.addMenuItem(path + "charDb.xml", i++);
        }
    }

    private void addMenuItem(String fullPath, int index) {
        File file = new File(fullPath);
        LoadDb action = new LoadDb(file);
        action.setIndexedDisplay(index);
        JMenuItem menuItem = new JMenuItem(action);
        menuItem.setMnemonic(Integer.toString(index).charAt(0));
        this.add(menuItem);
    }

    public JComponent[] getMenuPresenters() {
        this.refreshMenu();
        return new JComponent[]{this};
    }

    public JComponent[] synchMenuPresenters(JComponent[] items) {
        return this.getMenuPresenters();
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IFileUseMgr.class.getName())) {
            this.refreshMenu();
        }
    }
}

