/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.lifecycle;

import com.harrand.coreclasses.dataEntry.OpenEditorVO;
import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.command.provider.IOpenSqlFile;
import com.harrand.dbwrench.command.provider.Nb8ActionBuilderProvider;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.IDatabaseStore;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.SqlText;
import com.harrand.dbwrenchgui.panel.support.DbwEditorSupport;
import com.harrand.dbwrenchnb.action.diagram.ShowDiagram;
import com.harrand.dbwrenchnb.action.edit.ShowEditor;
import com.harrand.dbwrenchnb.diagram.DiagramTC;
import com.harrand.dbwrenchnb.diagram.NewDiagramMonitor;
import com.harrand.dbwrenchnb.editor.EditorTC;
import com.harrand.dbwrenchnb.lifecycle.db.DbFullDirtyChecker;
import com.harrand.dbwrenchnb.lifecycle.db.DbSaveChecker;
import com.harrand.dbwrenchnb.lifecycle.prefs.DefaultColorInitializer;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.panel.status.DesignFileStatusPanel;
import com.harrand.sketch.core.Diagram;
import java.util.List;
import javax.swing.JPanel;
import org.openide.windows.TopComponent;

public class SetDb
implements IDatabaseStore,
IDirtyTracker {
    private static final SetDb instance__ = new SetDb();
    private Database db_;
    private boolean checkSaveFlag_ = true;
    private final NewDiagramMonitor newDiagramMonitor_ = new NewDiagramMonitor();

    private SetDb() {
    }

    public static SetDb getInstance() {
        return instance__;
    }

    public void set(Database db) {
        if (this.db_ != null) {
            if (this.checkSaveFlag_) {
                this.checkSave();
            }
            this.db_.setDirtyTracker(null);
        }
        this.db_ = db;
        NbUtil.closeEditors();
        LookupUtil.postDb(this.db_);
        this.openEditors();
        this.openSqlCommunicatorEditors();
        DataTypeSvr.setDb(this.db_);
        this.db_.setDirtyTracker(this);
        this.newDiagramMonitor_.setDatabase(this.db_);
        DefaultColorInitializer.initDbwColors();
        this.clearDirty();
        CommandChainMgr.getInstance().getCommandChain().clear();
    }

    public void clearDirty() {
        this.db_.setDirty(false);
        this.updateStatusPanel();
    }

    public boolean getDirty() {
        DbFullDirtyChecker dirtyChecker = new DbFullDirtyChecker();
        return dirtyChecker.getDirty();
    }

    public void setCheckSaveFlag(boolean checkSaveFlag) {
        this.checkSaveFlag_ = checkSaveFlag;
    }

    private void openEditors() {
        DbwEditorSupport editorSupport = new DbwEditorSupport();
        String selectedTC_title = null;
        String selectedTC_classNm = null;
        int i = 0;
        List<OpenEditorVO> VOs = this.db_.getOpenEditors();
        for (OpenEditorVO VO : VOs) {
            CollectorIdf collIdf = VO.getCollectorIdf();
            Identifiable idf = collIdf.getIdentifiable();
            String TC_classNm = null;
            String TC_title = null;
            if (idf instanceof Diagram) {
                ShowDiagram showDiagram = new ShowDiagram((Diagram)idf);
                showDiagram.actionPerformed(null);
                TC_title = showDiagram.getTC_Title();
                TC_classNm = DiagramTC.class.getName();
            } else {
                JPanel panel = editorSupport.getTC_EditorPanel(collIdf);
                ShowEditor showEditor = new ShowEditor(panel, null);
                showEditor.actionPerformed(null);
                TC_title = showEditor.getTC_Title();
                TC_classNm = EditorTC.class.getName();
            }
            if (VO.getSelected() || i == 0) {
                selectedTC_title = TC_title;
                selectedTC_classNm = TC_classNm;
            }
            ++i;
        }
        if (selectedTC_classNm != null) {
            String lTC_title = selectedTC_title;
            String lTC_classNm = selectedTC_classNm;
            TopComponent tc = NbUtil.findTopComponent(lTC_classNm, lTC_title);
            tc.requestActive();
        }
    }

    private void openSqlCommunicatorEditors() {
        List<SqlText> sqlTexts = this.db_.getSqlTextStore().getSqlTexts();
        for (SqlText sqlText : sqlTexts) {
            IOpenSqlFile openSqlFile = Nb8ActionBuilderProvider.getInstance().getOpenSqlFile();
            openSqlFile.openEditor(sqlText);
        }
    }

    @Override
    public Database getDatabase() {
        return LookupUtil.findDb();
    }

    @Override
    public void setDatabase(Database db) {
        this.set(db);
    }

    @Override
    public void checkSave() {
        this.checkSave(true);
    }

    public void checkSave(boolean useMultithreadedSave) {
        DbSaveChecker saveChecker = new DbSaveChecker();
        saveChecker.checkSave(useMultithreadedSave);
    }

    @Override
    public void notifyDirty(Object src) {
        this.db_.setDirty(true);
        this.updateStatusPanel();
    }

    public void updateStatusPanel() {
        DesignFileStatusPanel statusPanel = DesignFileStatusPanel.getInstance();
        if (statusPanel != null) {
            statusPanel.setDirty(this.getDirty());
        }
    }
}

