/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.lifecycle;

import com.harrand.dbwrenchgui.sub.NbEditPanel;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.io.File;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EditorFontInitializer {
    private static final String FONT_COLOR_ELM_NM = "fontcolor";
    private static final String NAME_ATTR_NM = "name";
    private static final String DEFAULT_STR = "default";

    public void listEditorSettingsFCS() {
        MimePath mimePath = MimePath.parse((String)"text/x-sql");
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        FontColorSettings fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
    }

    public void checkEditorFontSet() {
    }

    private boolean checkInitFonts() {
        return NbEditPanel.checkInitFonts();
    }

    private void checkForDefaultFontColorTag(FileObject fontFO) {
        File fontFile = FileUtil.toFile((FileObject)fontFO);
        Document doc = XmlHelper.loadDocument(fontFile);
        if (doc != null) {
            Element elmRoot = doc.getDocumentElement();
            Element elmDefault = XmlHelper.getFirstElementByTagAndAttr(elmRoot, FONT_COLOR_ELM_NM, NAME_ATTR_NM, DEFAULT_STR);
            if (elmDefault == null) {
                LogUtil.logMsg("EditorFontInitializer.Default NOT found");
                this.replaceFile(fontFile);
            } else {
                LogUtil.logMsg("EditorFontInitializer.default FOUND");
            }
        } else {
            LogUtil.logErr("EditorFontInitializer.fontFile.doc is null: " + fontFile.getAbsolutePath());
        }
    }

    private String contentStr() {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE fontscolors PUBLIC \"-//NetBeans//DTD Editor Fonts and Colors settings 1.1//EN\" \"http://www.netbeans.org/dtds/EditorFontsColors-1_1.dtd\">\n<fontscolors>\n<fontcolor name=\"error\" waveUnderlined=\"red\"/>\n<fontcolor foreColor=\"ffce7b00\" name=\"char\"/>\n<fontcolor foreColor=\"ff0000e6\" name=\"keyword\"/>\n<fontcolor foreColor=\"black\" name=\"whitespace\"/>\n<fontcolor default=\"keyword\" name=\"markup-element\"/>\n<fontcolor foreColor=\"black\" name=\"number\"/>\n<fontcolor name=\"operator\"/>\n<fontcolor default=\"identifier\" foreColor=\"ff009900\" name=\"field\"/>\n<fontcolor bgColor=\"white\" foreColor=\"black\" name=\"default\">\n   <font name=\"Monospaced\" size=\"12\"/>\n</fontcolor>\n<fontcolor foreColor=\"ffce7b00\" name=\"string\"/>\n<fontcolor default=\"default\" foreColor=\"black\" name=\"entity-reference\">\n   <font style=\"bold\"/>\n</fontcolor>\n<fontcolor default=\"string\" name=\"markup-attribute-value\"/>\n<fontcolor default=\"identifier\" name=\"method\"/>\n<fontcolor foreColor=\"ff969696\" name=\"comment\"/>\n<fontcolor name=\"identifier\"/>\n<fontcolor name=\"separator\"/>\n<fontcolor default=\"field\" name=\"markup-attribute\"/>\n</fontscolors>";
        return content;
    }

    private void replaceFile(File fontFile) {
        String filePath = fontFile.getPath();
        fontFile.delete();
        String str = this.contentStr();
        FileHelper.saveStringToFile(str, filePath);
    }

    private void addDefaultElm(Document doc, Element elmFontsColors) {
        Element elmFontColor = doc.createElement(FONT_COLOR_ELM_NM);
        elmFontColor.setAttribute(NAME_ATTR_NM, DEFAULT_STR);
        elmFontColor.setAttribute("bgColor", "white");
        elmFontColor.setAttribute("foreColor", "black");
        Element elmFont = doc.createElement("font");
        elmFont.setAttribute(NAME_ATTR_NM, "Monospaced");
        elmFont.setAttribute("size", "12");
        elmFontColor.appendChild(elmFont);
        elmFontsColors.appendChild(elmFontColor);
        String xmlStr = XmlHelper.getStringFromElement(elmFontsColors);
        LogUtil.logMsg("EditorFontInitializer.xmlStr: " + xmlStr);
    }

    private void writeXmlFile(Element elmRoot, File fontFile) {
        try {
            XmlHelper.writeElement(elmRoot, fontFile);
        }
        catch (Exception ex) {
            LogUtil.logErr("EditorFontInitiallizer.Failed to write file. Err: " + ex.getMessage());
        }
    }
}

