/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.lifecycle;

import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.element.CollectorProvider;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.command.DbwCmdFactory;
import com.harrand.dbwrenchgui.panel.lic.LicensingUI_Ctrl;
import com.harrand.dbwrenchnb.action.db.LoadDb;
import com.harrand.dbwrenchnb.action.diagram.ShowDiagram;
import com.harrand.dbwrenchnb.action.edit.EditorActionFactory;
import com.harrand.dbwrenchnb.action.edit.RedoAction;
import com.harrand.dbwrenchnb.action.edit.UndoAction;
import com.harrand.dbwrenchnb.lifecycle.SetDb;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.nb.NbWindowUtil;
import com.harrand.dbwrenchnb.panel.status.DesignFileStatusPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.support.clipboard.GlyphClipboard;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import com.harrand.util.SysUtil;
import java.io.File;
import org.openide.awt.ToolbarPool;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DevSetup {
    public static final int MIN_MEGA_BYTES = 200;
    public static final String NEW_DB_NM = "newDb";

    public static void loadDevSetup() {
        DevSetup.initInstall();
        ToolbarPool.getDefault().setPreferredIconSize(16);
        App.setEditorActionFactory(EditorActionFactory.getInstance());
        DevSetup.doDelayed();
    }

    private static void closeUnneededWindows() {
        DevSetup.closeTc("runtime");
        DevSetup.closeTc("projectTab_tc");
        DevSetup.closeTc("projectTabLogical_tc");
    }

    private static void closeTc(String tcId) {
        WindowManager winMgr = WindowManager.getDefault();
        TopComponent tc = winMgr.findTopComponent(tcId);
        if (tc != null && tc.isOpened()) {
            tc.close();
        }
    }

    private static void doDelayed() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                DevSetup.initUndoRedoActions();
                DevSetup.loadDb();
                DevSetup.logRuntimeInfoDisp();
                this.checkJavaVersion();
                DevSetup.checkMinimumRam();
                this.setWindowUtil();
                this.checkShowLicensePanel();
            }

            private void checkJavaVersion() {
                String jreStr = System.getProperty("java.version");
                SysUtil sysUtil = new SysUtil();
                boolean isNewerVersion = sysUtil.getIsJre5Up();
                if (!isNewerVersion) {
                    String msg = "DbWrench is optimized to run on Java 1.6 and up.\nPlease upgrade your Java Runtime (JRE) from www.java.com\nYour current JRE version is: " + jreStr;
                    GuiMessageHelper.showWarningMsg(null, "Java Version Outdated", msg);
                }
            }

            private void checkShowLicensePanel() {
                if (LicensingUI_Ctrl.getInstance().getShowLicensePanel()) {
                    NbUtil.openActivateTc("CodeInfoTopComponent");
                }
            }

            private void setWindowUtil() {
                NbWindowUtil windowUtil = NbWindowUtil.getInstance();
                CollectorProvider collProvider = CollectorProvider.getInstance();
                collProvider.setWindowUtil(windowUtil);
                DbwCmdFactory cmdFactory = DbwCmdFactory.getInstance();
                cmdFactory.setWindowUtil(windowUtil);
                GlyphClipboard glyphClipboard = GlyphClipboard.getInstance();
                glyphClipboard.setWindowUtil(windowUtil);
            }
        });
    }

    public static void checkMinimumRam() {
        Runtime runtime = Runtime.getRuntime();
        double mbytes = MathUtil.getMegaBytes(runtime.maxMemory());
        if (mbytes < 200.0) {
            GuiMessageHelper.showWarningMsg(null, "Low Memory", "DbWrench has less than 200 MB RAM allocated.\nIt is recommended that you increase this allocation.\nPlease see our FAQ page on our website.");
        }
    }

    private static void initInstall() {
        DevSetup.closeUnneededWindows();
    }

    private static void loadDb() {
        DevSetup.setDesignFileStatusText("(Loading last design...)");
        DevSetup.loadMostRecent();
    }

    private static void loadDbFromFile(File file) {
        LoadDb loadDb = new LoadDb(file);
        loadDb.actionPerformed(null);
    }

    private static void loadMostRecent() {
        IFileUseMgr fileUseMgr = App.getFileUseMgr();
        File file = fileUseMgr.getMostRecentFile("Database");
        if (file != null) {
            DevSetup.loadDbFromFile(file);
        } else {
            DevSetup.openFirstTimeDb();
        }
    }

    private static void initUndoRedoActions() {
        CommandChain cmdChain = CommandChainMgr.getCmdChain();
        UndoAction undoAction = UndoAction.getInstance();
        RedoAction redoAction = RedoAction.getInstance();
        undoAction.setCmdChain(cmdChain);
        redoAction.setCmdChain(cmdChain);
    }

    private static void openFirstTimeDb() {
        long start = System.currentTimeMillis();
        Database newDb = new Database(NEW_DB_NM);
        newDb.addDefaultDiagram();
        SetDb setDb = SetDb.getInstance();
        setDb.setDatabase(newDb);
        Diagram diagram = newDb.getDiagram("diagramA");
        ShowDiagram showDiagram = new ShowDiagram(diagram);
        showDiagram.actionPerformed(null);
        long elapsedTime = System.currentTimeMillis() - start;
    }

    private static void setDesignFileStatusText(String text) {
        DesignFileStatusPanel panel = DesignFileStatusPanel.getInstance();
        if (panel != null) {
            panel.setText(text);
        }
    }

    private static void logRuntimeProp(String text, String propNm) {
        LogUtil.logErr(text + ": " + System.getProperty(propNm));
    }

    private static void logRuntimeValue(String text, String valueStr) {
        LogUtil.logErr(text + ": " + valueStr);
    }

    private static void logRuntimeInfoDisp() {
        Runtime runtime = Runtime.getRuntime();
        LogUtil.logErr("DbWrench Version: " + App.getVersion());
        DevSetup.logRuntimeProp("Java Version", "java.version");
        DevSetup.logRuntimeProp("OS Name", "os.name");
        DevSetup.logRuntimeProp("OS Version", "os.version");
        DevSetup.logRuntimeValue("Memory Allocated", StrHelper.getMegaBytesFormatted(runtime.maxMemory()) + " MB");
    }
}

