/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.editor.completion;

import com.harrand.coregui.Icons;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrenchgui.text.completion.popupMenu.CodeCompletionItem;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class EntityCompletionItemBldr {
    private static EntityCompletionItemBldr instance__ = null;
    private List<CodeCompletionItem> items_ = new ArrayList<CodeCompletionItem>();
    private Database db_;
    private Schema schema;
    private Table table;
    private String lcWordStart;
    private String lcPhrase;
    private String[] parts;
    public static final String DOT_SPLIT_STR = "\\.";

    public static EntityCompletionItemBldr getInstance() {
        if (instance__ == null) {
            instance__ = new EntityCompletionItemBldr();
        }
        return instance__;
    }

    public List<CodeCompletionItem> getCompletionItems(String currentWordStart, String currentPhrase) {
        this.items_ = new ArrayList<CodeCompletionItem>();
        this.db_ = LookupUtil.getLookupDb();
        this.lcWordStart = currentWordStart.toLowerCase();
        this.lcPhrase = currentPhrase.toLowerCase();
        if (this.db_ != null) {
            this.calcDotCount();
            this.checkSchemaSet();
            this.checkTableSet();
            this.addSchemaNms();
            this.addTblNms();
            this.addProcNms();
            this.addViewNms();
            this.addSeqNms();
            this.addColNms();
            this.addIdxNms();
            this.addTrgNms();
            this.addFkNms();
        }
        return new ArrayList<CodeCompletionItem>(this.items_);
    }

    private void addCompletionItem(String name, ImageIcon icon) {
        boolean isDup;
        String nameLC = name.toLowerCase();
        boolean matchesPrefix = nameLC.startsWith(this.lcWordStart);
        boolean emptyPrefix = this.lcWordStart.isEmpty();
        if ((emptyPrefix || matchesPrefix) && !(isDup = this.isDuplicateEntry(name))) {
            CodeCompletionItem item = new CodeCompletionItem(name, icon);
            this.items_.add(item);
        }
    }

    private void addSchemaNms() {
        if (this.isSchemaSet() || this.isTableSet()) {
            return;
        }
        for (Schema sch : this.db_.getSchemas()) {
            this.addCompletionItem(sch.getName(), Icons.SCHEMA);
        }
    }

    private void addTblNms() {
        if (this.isTableSet()) {
            return;
        }
        List<Table> tbls = this.isSchemaSet() ? this.schema.getTables() : this.db_.getAllTablesGen();
        for (Table tbl : tbls) {
            this.addCompletionItem(tbl.getName(), Icons.TABLE);
        }
    }

    private void addProcNms() {
        if (this.isTableSet()) {
            return;
        }
        List<Proc> procs = this.isSchemaSet() ? this.schema.getProcs() : this.db_.getAllProcs();
        for (Proc proc : procs) {
            this.addCompletionItem(proc.getName(), Icons.PROC);
        }
    }

    private void addViewNms() {
        if (this.isTableSet()) {
            return;
        }
        List<View> views = this.isSchemaSet() ? this.schema.getViews() : this.db_.getAllViewsGen();
        for (View view : views) {
            this.addCompletionItem(view.getName(), Icons.VIEW);
        }
    }

    private void addSeqNms() {
        if (this.isTableSet()) {
            return;
        }
        List<Sequence> seqs = this.isSchemaSet() ? this.schema.getSequences() : this.db_.getAllSeqs();
        for (Sequence seq : seqs) {
            this.addCompletionItem(seq.getName(), Icons.SEQUENCE);
        }
    }

    private void addColNms() {
        if (this.isOnlySchemaSet()) {
            return;
        }
        List<Column> cols = this.isTableSet() ? this.table.getColumns() : this.db_.getAllColumns();
        for (Column col : cols) {
            this.addCompletionItem(col.getName(), Icons.COLUMN);
        }
    }

    private void addIdxNms() {
        if (this.isOnlySchemaSet()) {
            return;
        }
        List<Index> idxs = this.isTableSet() ? this.table.getIndexes() : this.db_.getAllIndexes();
        for (Index idx : idxs) {
            this.addCompletionItem(idx.getName(), Icons.INDEX);
        }
    }

    private void addTrgNms() {
        if (this.isOnlySchemaSet()) {
            return;
        }
        List<Trigger> trgs = this.isTableSet() ? this.table.getTriggers() : this.db_.getAllTriggers();
        for (Trigger trg : trgs) {
            this.addCompletionItem(trg.getName(), Icons.TRIGGER);
        }
    }

    private void addFkNms() {
        if (this.isOnlySchemaSet()) {
            return;
        }
        List<ForeignKey> fks = this.isTableSet() ? this.table.getFks() : this.db_.getAllFKs();
        for (ForeignKey fk : fks) {
            this.addCompletionItem(fk.getName(), Icons.FOREIGN_KEY);
        }
    }

    private boolean isDuplicateEntry(String name) {
        boolean isDup = false;
        for (CodeCompletionItem item : this.items_) {
            if (!item.getText().equals(name)) continue;
            isDup = true;
            return isDup;
        }
        return isDup;
    }

    private void calcDotCount() {
        this.parts = this.lcPhrase.split(DOT_SPLIT_STR);
    }

    private void checkSchemaSet() {
        String firstStr;
        this.schema = null;
        if (this.lcPhrase.contains(".") && this.parts.length > 0 && !(firstStr = this.parts[0]).isEmpty() && this.db_.contains(Schema.getClassName(), firstStr)) {
            this.schema = this.db_.getSchema(firstStr);
        }
    }

    private void checkTableSet() {
        String part;
        this.table = null;
        if (this.parts.length > 1 && !(part = this.parts[1]).isEmpty()) {
            if (this.schema != null && this.schema.contains(Table.getClassName(), part)) {
                this.table = this.schema.getTable(part);
            }
            if (!this.isTableSet()) {
                this.attemptFindTable(this.parts[0]);
            }
        }
        if (!this.isTableSet() && this.parts.length == 1 && !(part = this.parts[0]).isEmpty()) {
            this.attemptFindTable(part);
        }
    }

    private void attemptFindTable(String tableName) {
        for (Schema sch : this.db_.getSchemas()) {
            if (!sch.containsTable(tableName)) continue;
            this.table = sch.getTable(tableName);
            break;
        }
    }

    private boolean isSchemaSet() {
        return this.schema != null;
    }

    private boolean isTableSet() {
        return this.table != null;
    }

    private boolean isOnlySchemaSet() {
        return this.isSchemaSet() && !this.isTableSet();
    }
}

