/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.editor.completion;

import com.harrand.dbwrenchgui.text.completion.popupMenu.CodeCompletionItem;
import com.harrand.dbwrenchnb.editor.completion.EntityCompletionItemBldr;
import com.harrand.dbwrenchnb.editor.completion.KeywordCompletionItemBldr;
import com.harrand.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CodeCompletionItemBldr {
    private final KeywordCompletionItemBldr keywordCompletionItemBldr = new KeywordCompletionItemBldr();
    private final EntityCompletionItemBldr entityCompletionItemBldr = new EntityCompletionItemBldr();
    private String currentWord;
    private String currentPhrase;

    public List<CodeCompletionItem> getCodeCompletionItems(String currentWord, String currentPhrase) {
        this.currentWord = currentWord;
        this.currentPhrase = currentPhrase;
        ArrayList<CodeCompletionItem> codeCompletionItems = new ArrayList<CodeCompletionItem>();
        boolean isCurrentWordValid = Validator.isStringValid(currentWord);
        boolean isCurrentPhraseValid = Validator.isStringValid(currentPhrase);
        if (isCurrentWordValid || isCurrentPhraseValid) {
            if (currentPhrase == null || !currentPhrase.contains(".")) {
                codeCompletionItems.addAll(this.getKeywordCompletionItems());
            }
            codeCompletionItems.addAll(this.getEntityCompletionItems());
            Collections.sort(codeCompletionItems);
        }
        return codeCompletionItems;
    }

    private Collection<CodeCompletionItem> getKeywordCompletionItems() {
        return this.keywordCompletionItemBldr.getCompletionItems(this.currentWord);
    }

    private Collection<CodeCompletionItem> getEntityCompletionItems() {
        return this.entityCompletionItemBldr.getCompletionItems(this.currentWord, this.currentPhrase);
    }
}

