/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.diagram;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.sketch.core.Diagram;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class Slider {
    private JScrollPane scrollPane_;
    private Point slideStart_ = null;
    private Point preSlideOrigin_ = null;

    public Slider(JScrollPane scrollPane, Diagram diagram) {
        this.scrollPane_ = scrollPane;
    }

    private void slideDiagram(Point currentPt) {
        double dragX = this.slideStart_.getX() - currentPt.getX();
        double dragY = this.slideStart_.getY() - currentPt.getY();
        JViewport vp = this.scrollPane_.getViewport();
        Dimension vpSz = vp.getSize();
        Dimension viewSz = vp.getViewSize();
        double maxOriginX = viewSz.getWidth() - vpSz.getWidth();
        double newOriginX = this.preSlideOrigin_.getX() + dragX;
        if (newOriginX > maxOriginX) {
            newOriginX = maxOriginX;
        }
        if (newOriginX < 0.0) {
            newOriginX = 0.0;
        }
        double maxOriginY = viewSz.getHeight() - vpSz.getHeight();
        double newOriginY = this.preSlideOrigin_.getY() + dragY;
        if (newOriginY > maxOriginY) {
            newOriginY = maxOriginY;
        }
        if (newOriginY < 0.0) {
            newOriginY = 0.0;
        }
        Point newPt = new Point((int)newOriginX, (int)newOriginY);
        vp.setViewPosition(newPt);
    }

    public void clear() {
        GuiHelper.setDefaultCursor(this.scrollPane_);
        this.slideStart_ = null;
        this.preSlideOrigin_ = null;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point currentPt = mouseEvent.getPoint();
        if (this.slideStart_ != null) {
            this.slideDiagram(currentPt);
        } else {
            this.slideStart_ = currentPt;
            this.preSlideOrigin_ = this.scrollPane_.getViewport().getViewPosition();
        }
    }
}

