/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.diagram;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchnb.action.diagram.CloseDiagram;
import com.harrand.dbwrenchnb.action.diagram.ShowDiagram;
import com.harrand.sketch.core.Diagram;
import java.util.ArrayList;
import java.util.List;

public class NewDiagramMonitor
implements IObserver {
    private List<Diagram> lastDiagrams_ = new ArrayList<Diagram>();
    private Database db_;
    private boolean enabled = true;

    public void setDatabase(Database db) {
        this.db_ = db;
        this.db_.addObserver(this);
        this.db_.setNewDiagramMonitor(this);
        this.storeDiagrams();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void update(UpdateChain chain) {
        if (this.isEnabled() && chain.hasClassName(Diagram.getClassName())) {
            this.checkNewDiagram();
            this.checkDeletedDiagram();
            this.storeDiagrams();
        }
    }

    private void checkDeletedDiagram() {
        ArrayList<Diagram> currentDiagrams = new ArrayList<Diagram>();
        for (Object obj : this.db_.getDiagrams()) {
            currentDiagrams.add((Diagram)obj);
        }
        ArrayList<Diagram> lastDiagramsDup = new ArrayList<Diagram>(this.lastDiagrams_);
        lastDiagramsDup.removeAll(currentDiagrams);
        if (!lastDiagramsDup.isEmpty()) {
            Diagram diagram0 = (Diagram)lastDiagramsDup.get(0);
            CloseDiagram closeDiagram = new CloseDiagram(diagram0);
            closeDiagram.close();
        }
    }

    private void checkNewDiagram() {
        ArrayList<Diagram> newDiagrams = new ArrayList<Diagram>();
        for (Object obj : this.db_.getDiagrams()) {
            newDiagrams.add((Diagram)obj);
        }
        newDiagrams.removeAll(this.lastDiagrams_);
        for (Diagram diagram : newDiagrams) {
            ShowDiagram showDiagram = new ShowDiagram(diagram);
            showDiagram.actionPerformed(null);
        }
    }

    private void storeDiagrams() {
        this.lastDiagrams_.clear();
        for (Object obj : this.db_.getDiagrams()) {
            this.lastDiagrams_.add((Diagram)obj);
        }
    }
}

