/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.db.query;

import com.harrand.coregui.Icons;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.panel.general.QueryTextPanel;
import java.awt.BorderLayout;
import java.util.logging.Logger;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class QueryTextTC
extends TopComponent {
    private static QueryTextTC instance;
    private QueryTextPanel textPanel = new QueryTextPanel();
    private DbQuery query;
    public static final String DISPLAY_NM = "Query Text";
    public static final String PREFERRED_ID = "QueryTextTC";

    private QueryTextTC() {
        this.setDisplayProps();
        this.buildPanel();
    }

    public void setQuery(DbQuery query) {
        this.query = query;
        this.textPanel.setQuery(query);
    }

    public DbQuery getQuery() {
        return this.query;
    }

    private void setDisplayProps() {
        this.setName(PREFERRED_ID);
        this.setToolTipText(DISPLAY_NM);
        this.setDisplayName(DISPLAY_NM);
        this.setIcon(Icons.QUERY_BLDR.getImage());
    }

    public int getPersistenceType() {
        return 0;
    }

    public static synchronized QueryTextTC getDefault() {
        if (instance == null) {
            instance = new QueryTextTC();
        }
        return instance;
    }

    public static synchronized QueryTextTC findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(QueryTextTC.class.getName()).warning("Cannot find QueryTextTC component. It will not be located properly in the window system.");
            return QueryTextTC.getDefault();
        }
        if (win instanceof QueryTextTC) {
            return (QueryTextTC)win;
        }
        Logger.getLogger(QueryTextTC.class.getName()).warning("There seem to be multiple components with the 'QueryTextTC' ID. That is a potential source of errors and unexpected behavior.");
        return QueryTextTC.getDefault();
    }

    private void buildPanel() {
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.textPanel, "Center");
    }
}

