/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.action.diagram.support;

import com.harrand.coreclasses.zoom.IZoomable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrenchnb.diagram.DiagramTC;
import com.harrand.dbwrenchnb.editor.EditorTC;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.sketch.zoom.ZoomCommand;
import java.awt.event.ActionEvent;

public class ZoomCmdDisp {
    public void doZoom(ActionEvent e, int direction) {
        this.doDispatch(e, null, direction);
    }

    public void doZoom(ActionEvent e, Zoom newZoom) {
        this.doDispatch(e, newZoom, null);
    }

    private void doDispatch(ActionEvent evt, Zoom newZoom, Integer direction) {
        IZoomable zoomable = this.getShowingZoomable();
        if (zoomable != null) {
            double zoomLevel = newZoom != null ? newZoom.getLevel() : this.getNextZm(zoomable, direction);
            ZoomCommand cmd = new ZoomCommand(zoomable, zoomLevel);
            cmd.actionPerformed(evt);
        } else {
            GuiMessageHelper.showWarningMsg(null, "No Diagram Showing", "No Diagram Showing to Zoom");
        }
    }

    private double getNextZm(IZoomable zoomable, int direction) {
        Zoom zoom = zoomable.getZoom();
        double newLevel = zoom.getNextZoom(direction).getLevel();
        return newLevel;
    }

    private IZoomable getShowingZoomable() {
        DiagramTC tc = this.findShowingDiagramTC();
        if (tc != null) {
            return tc;
        }
        IZoomable editorZoomable = this.findEditorZoomable();
        return editorZoomable;
    }

    private DiagramTC findShowingDiagramTC() {
        DiagramTC tc = (DiagramTC)NbUtil.findShowingSelectedTC(DiagramTC.class.getName());
        return tc;
    }

    private IZoomable findEditorZoomable() {
        EditorTC editTc = (EditorTC)NbUtil.findShowingSelectedTC(EditorTC.class.getName());
        if (editTc != null) {
            IZoomable zoomable = editTc.getZoomable();
            return zoomable;
        }
        return null;
    }
}

