/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.action.db;

import com.google.common.base.Strings;
import com.harrand.coreclasses.dataEntry.ITextEditor;
import com.harrand.coreclasses.dataEntry.OpenEditorVO;
import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.SqlText;
import com.harrand.dbwrench.object.SqlTextStore;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchnb.action.db.IExplorerExpandedPathsProvider;
import com.harrand.dbwrenchnb.action.db.LoadDb;
import com.harrand.dbwrenchnb.action.db.SaveContext;
import com.harrand.dbwrenchnb.diagram.DiagramTC;
import com.harrand.dbwrenchnb.editor.EditorTC;
import com.harrand.dbwrenchnb.lifecycle.SetDb;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.util.ErrMsg;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class SaveUtil {
    private static final SaveUtil instance__ = new SaveUtil();
    private Database db_;
    private IExplorerExpandedPathsProvider explorerExpandedPathsProvider;

    private SaveUtil() {
    }

    public static SaveUtil getInstance() {
        return instance__;
    }

    public void saveAll() {
        SaveContext saveContext = new SaveContext();
        saveContext.setIsAutoSave(false);
        saveContext.setIsSaveAs(false);
        saveContext.setUseMultithreadedSave(false);
        this.saveEdits(saveContext);
        this.saveFile(saveContext);
    }

    public void saveAll(SaveContext saveContext) {
        this.saveEdits(saveContext);
        this.saveFile(saveContext);
    }

    public void saveEdits(SaveContext saveContext) {
        Set<TopComponent> comps = NbUtil.getOpenWindows();
        for (TopComponent tc : comps) {
            if (!(tc instanceof EditorTC)) continue;
            ((EditorTC)tc).saveIfDirty(saveContext);
        }
    }

    public void saveFile(SaveContext saveContext) {
        this.lookupDb();
        if (this.isA_DesignOpen()) {
            if (this.checkFileName(saveContext.getIsSaveAs())) {
                this.storeWhichEditorsAreOpen();
                this.storeDbExpPaths();
                this.storeSqlTexts();
                this.writeDisp(saveContext.getUseMultithreadedSave());
            }
        } else {
            GuiMessageHelper.showWarningMsg(null, "Save Design File", "No database design file is open to save.");
        }
    }

    private void storeSqlTexts() {
        SqlTextStore store = this.db_.getSqlTextStore();
        store.clear();
        Set comps = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : comps) {
            boolean isTextEditor = tc instanceof ITextEditor;
            if (tc == null || !isTextEditor) continue;
            ITextEditor textEditor = (ITextEditor)tc;
            SqlText sqlText = new SqlText(textEditor.getFilePath(), textEditor.getText());
            store.addSqlText(sqlText);
            if (Strings.isNullOrEmpty((String)textEditor.getFilePath())) continue;
            textEditor.saveFile();
        }
    }

    private void storeWhichEditorsAreOpen() {
        ArrayList<OpenEditorVO> openCollIdfs = new ArrayList<OpenEditorVO>();
        Set comps = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : comps) {
            CollectorIdf collIdf = null;
            OpenEditorVO openEditorVO = null;
            boolean isDiagramTC = tc instanceof DiagramTC;
            boolean isEditorTC = tc instanceof EditorTC;
            if (isEditorTC && tc != null) {
                EditorTC editorTC = (EditorTC)tc;
                Collector coll = editorTC.getCollector();
                Identifiable idf = editorTC.getIdentifiable();
                if (coll != null && idf != null) {
                    collIdf = new CollectorIdf(coll, idf);
                    openEditorVO = new OpenEditorVO(collIdf, editorTC.isShowing());
                }
            } else if (isDiagramTC && tc != null) {
                DiagramTC diagramTC = (DiagramTC)tc;
                collIdf = new CollectorIdf(null, diagramTC.getDiagram());
                openEditorVO = new OpenEditorVO(collIdf, diagramTC.isShowing());
            }
            if (openEditorVO == null) continue;
            openCollIdfs.add(openEditorVO);
        }
        Collections.reverse(openCollIdfs);
        this.db_.setOpenEditors(openCollIdfs);
    }

    private void storeDbExpPaths() {
        if (this.explorerExpandedPathsProvider != null) {
            List<String> expandedPaths = this.explorerExpandedPathsProvider.getExpandedPaths();
            this.db_.setExplorerPaths(expandedPaths);
        }
    }

    private boolean checkFileName(boolean isSaveAs) {
        boolean fileSet;
        boolean bl = isSaveAs ? false : (fileSet = this.db_.getFolder() != null);
        if (!fileSet) {
            this.writeStatus("Opening Save Dialog ...");
            File file = this.promptForFile();
            if (file != null) {
                this.setDbFileName(this.db_, file);
                this.db_.setFolder(file.getParent());
                fileSet = true;
            }
        }
        return fileSet;
    }

    public IExplorerExpandedPathsProvider getExplorerExpandedPathsProvider() {
        return this.explorerExpandedPathsProvider;
    }

    public void setExplorerExpandedPathsProvider(IExplorerExpandedPathsProvider explorerExpandedPathsProvider) {
        this.explorerExpandedPathsProvider = explorerExpandedPathsProvider;
    }

    private File getDefaultFile() {
        String homeDirectory = System.getProperty("user.home");
        String userDirectory = System.getProperty("user.dir");
        LogUtil.logMsg(this, "DbUser's Mac user.home : " + homeDirectory);
        LogUtil.logMsg(this, "DbUser's Mac user.dir : " + userDirectory);
        LogUtil.logMsg(this, "DbUser appPath: " + App.getAppFolder());
        IFileUseMgr iFileUseMgr = App.getFileUseMgr();
        App.getFileUseMgr();
        File defaultFile = iFileUseMgr.getDefaultFile("Database", this.db_);
        return defaultFile;
    }

    private void lookupDb() {
        this.db_ = (Database)CentralLookup.getDefault().lookup(Database.class);
    }

    private File promptForFile() {
        File file = null;
        File defaultFile = this.getDefaultFile();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(ResMgr.getRes("save.as.label"));
        chooser.setSelectedFile(defaultFile);
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        int state = chooser.showSaveDialog(mainWindow);
        if (state == 0) {
            file = chooser.getSelectedFile();
        }
        return file;
    }

    private void setDbFileName(Database db_, File file) {
        String name = file.getName();
        name = name.replaceAll(".xml", "");
        name = name.replaceAll(".XML", "");
        db_.setFileName(name);
    }

    private void writeDisp(boolean useMultithreadedSave) {
        if (useMultithreadedSave) {
            this.writeMultithread();
        } else {
            this.writeSingleThread();
        }
    }

    private void writeSingleThread() {
        this.setStatusStarted();
        this.doWrite();
        this.setStatusDone();
        SetDb.getInstance().clearDirty();
    }

    private void writeMultithread() {
        this.setStatusStarted();
        if (SwingUtilities.isEventDispatchThread()) {
            this.writeOnRunnable();
        }
        this.setStatusDone();
        SetDb.getInstance().clearDirty();
    }

    private void setStatusDone() {
        this.writeStatus("Saved " + this.db_.getFilePath());
    }

    private void setStatusStarted() {
        this.writeStatus("Saving ...");
    }

    private void writeOnRunnable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SaveUtil.this.doWrite();
            }
        });
    }

    private void doWrite() {
        try {
            this.db_.write();
            LoadDb.setAsRecent(this.db_);
        }
        catch (IOException e) {
            LogUtil.logErr("SaveDb.writeRun().err: " + e.getMessage());
            GuiMessageHelper.showInputErrMsg(null, ErrMsg.getTitleIoError(), e.getMessage());
        }
    }

    private void writeStatus(String msg) {
        StatusDisplayer.getDefault().setStatusText(msg);
    }

    private boolean isA_DesignOpen() {
        return this.db_ != null;
    }
}

