/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.action.db;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchnb.lifecycle.SetDb;
import com.harrand.dbwrenchnb.nb.NbUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import org.openide.awt.StatusDisplayer;

public class LoadDb
extends AbstractAction {
    private final File file_;
    private Database db_;

    public LoadDb(File file) {
        this.file_ = file;
        this.putValue("SmallIcon", Icons.DATABASE);
        this.putValue("Name", this.file_.getAbsolutePath());
    }

    public void setIndexedDisplay(int index) {
        String numStr = Integer.toString(index);
        String str = numStr + ": " + this.file_.getAbsolutePath();
        this.putValue("Name", str);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getDbFromFile();
    }

    private void getDbFromFile() {
        ITestResult result = Database.validateFile(this.file_);
        if (result.getPassed()) {
            String openingStr = App.getResouceStringApp("global.title") + ": " + this.file_.getName() + " (opening...)";
            StatusDisplayer.getDefault().setStatusText(openingStr);
            SwingWorkerImpl worker = new SwingWorkerImpl();
            worker.execute();
        } else {
            GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail());
        }
    }

    public static void setAsRecent(Database db) {
        File file = new File(db.getFilePath());
        App.getFileUseMgr().addRecentFile("Database", file, true);
    }

    private class SwingWorkerImpl
    extends SwingWorker<Database, Void> {
        @Override
        public Database doInBackground() {
            LoadDb.this.db_ = Database.fromFile(LoadDb.this.file_);
            return LoadDb.this.db_;
        }

        @Override
        public void done() {
            try {
                String beforeTitle = NbUtil.getTitleBarText();
                String tempTitle = beforeTitle + " (loading database...)";
                NbUtil.setTitleBarText(tempTitle);
                LoadDb.this.db_.setFolder(LoadDb.this.file_.getParent() + File.separator);
                LoadDb.this.db_.setFileName(LoadDb.this.file_.getName());
                LoadDb.setAsRecent(LoadDb.this.db_);
                StatusDisplayer.getDefault().setStatusText(LoadDb.this.file_.getAbsolutePath() + " opened");
                NbUtil.openActivateTc("DbExplorerTopComponent");
                LoadDb.this.db_ = (Database)this.get();
                if (LoadDb.this.db_ != null) {
                    SetDb.getInstance().set(LoadDb.this.db_);
                }
                NbUtil.setTitleBarText(beforeTitle);
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
    }
}

