/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.transfer;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.interfaces.IStorable;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.transfer.SchemaTransferHistory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class SchemaTransferHistoryPanel
extends JPanel
implements IObserver,
ITitled,
ISized,
IStorable {
    private Database db_;
    private JTable transfersGrid_ = new JTable();
    private DefaultTableModel tableModel_ = new DefaultTableModel();
    private JScrollPane gridScroll_;
    private JLabel lblObjNm_ = new JLabel("Table");
    private JLabel lblPreviousSchemas_ = new JLabel("Previous Schemas");
    private JComboBox cboObj_ = new JComboBox();
    private JButton btnDeleteHistory_ = new JButton("Delete History");
    private ActionListener lisObj_;
    private Table lastSelectedTbl_ = null;
    private SwingThemeCtrl themeCtrl_;
    private String[] headers_ = new String[]{"#", "Schema", "Table Name at Transfer Time"};
    public static final String CLAZZ = "SchemaTranferHistoryPanel";
    public static final String TITLE = "Table Transfer History";

    public SchemaTransferHistoryPanel(Database db) {
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.addListeners();
        this.setDb(db);
    }

    public void setDb(Database db) {
        db.removeObserver(this);
        this.db_ = db;
        db.addObserver(this);
        this.loadObjCombo(false);
        this.refreshHistoryGrid();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getHistoryDetailsPanel(), "Center");
    }

    private XpHeaderPanel getHeaderPanel() {
        XpHeaderPanel panel = new XpHeaderPanel("Transfer of tables between schemas is tracked", "This transfer history is used to construct transfer DDL statements in forward engineer scripts.");
        return panel;
    }

    private JPanel getHistoryDetailsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.getObjComboPanel(), "North");
        panel.add((Component)this.getGridPanel(), "Center");
        panel.add((Component)this.getBtnPanel(), "South");
        GuiHelper.addBodyPanelBorder(panel);
        return panel;
    }

    private JPanel getObjComboPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairFixed(this.lblObjNm_, this.cboObj_, gbc, panel, row++);
        return panel;
    }

    private JPanel getGridPanel() {
        JPanel panel = new JPanel();
        this.transfersGrid_.setModel(this.tableModel_);
        this.gridScroll_ = new JScrollPane(this.transfersGrid_);
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.lblPreviousSchemas_, "North");
        panel.add((Component)this.gridScroll_, "Center");
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnDeleteHistory_);
        return panel;
    }

    private void setCosmetics() {
        this.transfersGrid_.setAutoResizeMode(0);
        this.transfersGrid_.setEnabled(false);
        Font oldFont = this.lblPreviousSchemas_.getFont();
        this.lblPreviousSchemas_.setFont(new Font(oldFont.getFamily(), 1, oldFont.getSize()));
        this.btnDeleteHistory_.setMnemonic('D');
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.transfersGrid_);
        this.themeCtrl_.process(this.gridScroll_);
    }

    private void addListeners() {
        this.lisObj_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Table tbl = SchemaTransferHistoryPanel.this.getSelectedTable();
                if (tbl != null) {
                    SchemaTransferHistoryPanel.this.lastSelectedTbl_ = tbl;
                }
                SchemaTransferHistoryPanel.this.refreshHistoryGrid();
            }
        };
        this.cboObj_.addActionListener(this.lisObj_);
        this.btnDeleteHistory_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaTransferHistoryPanel.this.deleteHistory();
            }
        });
    }

    private void setNames() {
        this.setName(TITLE);
        this.transfersGrid_.setName("transfersGrid");
        this.cboObj_.setName("cboObj");
        this.btnDeleteHistory_.setName("btnDeleteHistory");
    }

    private void refresh() {
        this.loadObjCombo(true);
        this.refreshHistoryGrid();
    }

    private void loadObjCombo(boolean keepSelectedItem) {
        Schema schema;
        this.cboObj_.removeAllItems();
        List tblNms = this.db_.getAllTableNmsOptionBrackets();
        Vector vTables = new Vector(tblNms);
        DefaultComboBoxModel cboModel = new DefaultComboBoxModel(vTables);
        this.cboObj_.removeActionListener(this.lisObj_);
        this.cboObj_.setModel(cboModel);
        this.cboObj_.addActionListener(this.lisObj_);
        if (keepSelectedItem && this.lastSelectedTbl_ != null && (schema = this.lastSelectedTbl_.getSchema()).containsTable(this.lastSelectedTbl_.getName())) {
            this.cboObj_.setSelectedItem(this.lastSelectedTbl_.getSchemaBracket());
        }
    }

    private void refreshHistoryGrid() {
        this.clearDetails();
        Table tbl = this.getSelectedTable();
        if (tbl != null) {
            SchemaTransferHistory history = tbl.getSchemaTransferHistory();
            List pairs = history.getTransferPairs();
            Object[][] dataVector = new Object[pairs.size()][this.headers_.length];
            int row = 0;
            for (int i = pairs.size() - 1; i >= 0; --i) {
                int col = 0;
                String idStr = Integer.toString(i + 1);
                StringPair pair = (StringPair)pairs.get(i);
                dataVector[row][col++] = idStr;
                dataVector[row][col++] = pair.getStrA();
                dataVector[row][col++] = pair.getStrB();
                ++row;
            }
            this.tableModel_.setDataVector(dataVector, this.headers_);
            GuiHelper.optimizeTableColumnWidths(this.transfersGrid_, 600);
        }
    }

    private void clearDetails() {
        Object[][] dataVector = new Object[0][0];
        this.tableModel_.setDataVector(dataVector, this.headers_);
    }

    private Table getSelectedTable() {
        Table tbl = null;
        String schBracket = (String)this.cboObj_.getSelectedItem();
        if (schBracket != null) {
            tbl = this.db_.getTableFromSchemaBracket(schBracket);
        }
        return tbl;
    }

    private void deleteHistory() {
        Table tbl = this.getSelectedTable();
        if (tbl != null) {
            if (this.transfersGrid_.getRowCount() > 0) {
                int response = GuiMessageHelper.showYesNoCancelMsg(null, "Confirm Delete", "Are you sure you want to delete the transfer history for: " + tbl.getSchemaBracket() + ".\n" + "It is ok to delete the transfer history after the transfers have been\n" + "applied to the database server.");
                if (response == 0) {
                    tbl.getSchemaTransferHistory().clearHistory();
                    this.refreshHistoryGrid();
                }
            } else {
                GuiMessageHelper.showInputErrMsg(null, "Invalid Selection", "There is no history to delete for this table.");
            }
        } else {
            GuiMessageHelper.showInputErrMsg(null, "Invalid Selection", "A table must first selected.");
        }
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(Table.getClassName())) {
            this.refresh();
        }
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(0, 0, 510, 340);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public String getStorageName() {
        return CLAZZ;
    }
}

