/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.transfer;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.IStorable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.command.ChangeSchema;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChangeSchemaPanel
extends JPanel
implements ITitled,
ISized,
IStorable,
IFocusable {
    private Database db_;
    private List idfs_;
    private Identifiable firstIdf_;
    private Schema schFirst_;
    private XpHeaderPanel header_;
    private JDialog parentDlg_;
    private JLabel lblObjType_ = new JLabel("Object Type");
    private JLabel lblObjNm_ = new JLabel("Object Name");
    private JLabel lblCurrSch_ = new JLabel("Current Schema");
    private JLabel lblNewSch_ = new JLabel("New Schema");
    private JTextField txtObjType_ = new JTextField();
    private JTextField txtObjNm_ = new JTextField();
    private JTextField txtCurrSch_ = new JTextField();
    private JComboBox cboNewSchema_ = new JComboBox();
    private ChangeSchema subCmd_ = null;
    private ActionListener lisOk_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
    public static final String TITLE = "Change Schema";
    public static final String CLAZZ = "ChangeSchemaPanel";
    public static final String MULTI_OBJS_MSG = "(Multiple Objects)";
    private static final int STATUS_ID = 0;

    public ChangeSchemaPanel(Database db) {
        this.db_ = db;
        this.setupGui();
    }

    public ITestResult setTransferIdfs(List idfs) {
        this.idfs_ = idfs;
        this.setFirstItems();
        this.loadNewSchemaCombo();
        this.loadData();
        return new DataEntryResult(true);
    }

    public void setParentDlg(JDialog parentDlg) {
        this.parentDlg_ = parentDlg;
    }

    public Schema getNewSchema() {
        return this.db_.getSchema((String)this.cboNewSchema_.getSelectedItem());
    }

    public ActionListener getOkListener() {
        return this.lisOk_;
    }

    private void setupGui() {
        this.layoutComponents();
        this.buildListeners();
        this.setCosmetics();
        this.setNames();
    }

    private void layoutComponents() {
        this.header_ = new XpHeaderPanel(TITLE, null);
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.header_, "North");
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairPadded(this.lblObjType_, this.txtObjType_, gbc, panel, row++);
        GuiHelper.addGridbagPairPadded(this.lblObjNm_, this.txtObjNm_, gbc, panel, row++);
        GuiHelper.addGridbagPairPadded(this.lblCurrSch_, this.txtCurrSch_, gbc, panel, row++);
        GuiHelper.addGridbagPairPadded(this.lblNewSch_, this.cboNewSchema_, gbc, panel, row++);
        GuiHelper.addBodyPanelBorder(panel);
        return panel;
    }

    private void loadNewSchemaCombo() {
        String currSchNm = this.schFirst_ != null ? this.schFirst_.getName() : "";
        Vector<String> schNms = new Vector<String>();
        for (String schNm : this.db_.getKeys(Schema.getClassName())) {
            if (schNm.equals(currSchNm)) continue;
            schNms.add(schNm);
        }
        DefaultComboBoxModel model = new DefaultComboBoxModel(schNms);
        this.cboNewSchema_.setModel(model);
    }

    private void buildListeners() {
        this.lisOk_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeSchemaPanel.this.doTransfer();
                if (ChangeSchemaPanel.this.parentDlg_ != null) {
                    ChangeSchemaPanel.this.parentDlg_.setVisible(false);
                    ChangeSchemaPanel.this.parentDlg_.dispose();
                }
            }
        };
    }

    private void doTransfer() {
        if (!this.checkNoDupAdds().getPassed()) {
            return;
        }
        CommandChain cmdChain = CommandChainMgr.getInstance().getCommandChain();
        Schema schNew = this.getNewSchema();
        this.subCmd_ = new ChangeSchema(schNew, this.idfs_);
        this.subCmd_.setCommandChain(cmdChain);
        this.subCmd_.actionPerformed(null);
    }

    private ITestResult checkNoDupAdds() {
        DataEntryResult mainRslt = new DataEntryResult(true);
        Schema schNew = this.getNewSchema();
        StringBuffer sb = new StringBuffer();
        for (Identifiable idf : this.idfs_) {
            ITestResult itemRslt = schNew.checkDuplicateName(idf.getMapName(), idf.getName());
            if (itemRslt.getPassed()) continue;
            sb.append("    " + idf.getDisplayClzNm() + ": " + idf.getName() + "\n");
        }
        if (sb.length() > 0) {
            String msg = "The following items already exist in the '" + schNew.getName() + "' schema:\n" + sb.toString();
            mainRslt = new DataEntryResult(false, "Duplicate Objects", msg);
            GuiMessageHelper.showInputErrMsg(null, mainRslt);
        }
        return mainRslt;
    }

    private void setFirstItems() {
        if (this.idfs_.size() == 1) {
            this.firstIdf_ = (Identifiable)this.idfs_.get(0);
            ISchemaObj firstObj = (ISchemaObj)((Object)this.firstIdf_);
            this.schFirst_ = firstObj.getSchema();
        } else {
            this.firstIdf_ = null;
            this.schFirst_ = null;
        }
    }

    private void loadData() {
        if (this.firstIdf_ != null) {
            this.txtObjType_.setText(this.firstIdf_.getDisplayClzNm());
            this.txtObjNm_.setText(this.firstIdf_.getName());
            this.txtCurrSch_.setText(this.schFirst_.getName());
        } else {
            this.txtObjType_.setText(MULTI_OBJS_MSG);
            this.txtObjNm_.setText(MULTI_OBJS_MSG);
            this.txtCurrSch_.setText(MULTI_OBJS_MSG);
        }
    }

    private void setCosmetics() {
        this.txtObjType_.setEditable(false);
        this.txtObjNm_.setEditable(false);
        this.txtCurrSch_.setEditable(false);
        Color disableColor = this.themeCtrl_.getUneditColumnBackground();
        this.txtObjType_.setBackground(disableColor);
        this.txtObjNm_.setBackground(disableColor);
        this.txtCurrSch_.setBackground(disableColor);
        this.themeCtrl_.process(this.txtObjType_);
        this.themeCtrl_.process(this.txtObjNm_);
        this.themeCtrl_.process(this.txtCurrSch_);
        this.cboNewSchema_.requestFocus();
    }

    private void setNames() {
        this.txtObjType_.setName("txtObjType");
        this.txtObjNm_.setName("txtObjNm");
        this.txtCurrSch_.setName("txtCurrSch");
        this.cboNewSchema_.setName("cboNewSchema");
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(0, 0, 430, 255);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public String getStorageName() {
        return CLAZZ;
    }

    @Override
    public void transferFocus() {
        this.cboNewSchema_.requestFocus();
    }
}

