/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.lexer.lexer;

import com.harrand.dbwrenchgui.text.lexer.lexer.ILexer;
import com.harrand.dbwrenchgui.text.lexer.range.TextRange;
import com.harrand.dbwrenchgui.text.lexer.token.IToken;
import com.harrand.dbwrenchgui.text.lexer.token.SingleQuoteToken;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SymmetricSpanLexer
implements ILexer {
    private final String startEndPattern;

    public SymmetricSpanLexer(String startEndPattern) {
        this.startEndPattern = startEndPattern;
    }

    @Override
    public List<IToken> lex(String text) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        Integer start = null;
        Pattern pattern = Pattern.compile(this.startEndPattern);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            if (start == null) {
                start = matcher.start();
                continue;
            }
            Integer end = matcher.end();
            SingleQuoteToken token = new SingleQuoteToken(new TextRange(start, end));
            tokens.add(token);
            start = null;
            end = null;
        }
        return tokens;
    }
}

