/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.lexer.lexer;

import com.harrand.coreclasses.db.SqlKeywords;
import com.harrand.dbwrenchgui.text.lexer.lexer.WordLexer;
import com.harrand.dbwrenchgui.text.lexer.range.TextRange;
import com.harrand.dbwrenchgui.text.lexer.token.IToken;
import com.harrand.dbwrenchgui.text.lexer.token.KeywordToken;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class KeywordLexer
extends WordLexer {
    private static final String[] KEYWORDS = SqlKeywords.KEYWORDS;

    KeywordLexer() {
    }

    @Override
    public List<IToken> lex(String text) {
        String preprocessed = super.preprocessText(text);
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        for (String keyword : KEYWORDS) {
            String regex = String.format("\\b%s\\b", keyword);
            Pattern pattern = Pattern.compile(regex, 2);
            Matcher matcher = pattern.matcher(preprocessed);
            while (matcher.find()) {
                KeywordToken token = new KeywordToken(new TextRange(matcher.start(), matcher.end()));
                tokens.add(token);
            }
        }
        return tokens;
    }
}

