/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.lexer.lexer;

import com.harrand.dbwrenchgui.text.lexer.lexer.ILexer;
import com.harrand.dbwrenchgui.text.lexer.range.TextRange;
import com.harrand.dbwrenchgui.text.lexer.token.CommentToken;
import com.harrand.dbwrenchgui.text.lexer.token.IToken;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AssymetricSpanLexer
implements ILexer {
    private final String startText;
    private final String endText;

    public AssymetricSpanLexer(String startText, String endText) {
        this.startText = startText;
        this.endText = endText;
    }

    @Override
    public List<IToken> lex(String text) {
        IToken token;
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        int endTextLength = this.endText.length();
        int searchStart = 0;
        do {
            if ((token = this.findNextToken(text, searchStart)) == null) continue;
            tokens.add(token);
            searchStart = token.getTextRange().getEnd();
        } while (token != null);
        return tokens;
    }

    private IToken findNextToken(String text, int searchStart) {
        if (searchStart >= text.length()) {
            return null;
        }
        String subText = text.substring(searchStart);
        Integer endEnd = subText.length();
        CommentToken token = null;
        Pattern startPattern = Pattern.compile(this.startText);
        Matcher startMatcher = startPattern.matcher(subText);
        if (startMatcher.find()) {
            int startStart = startMatcher.start();
            int startEnd = startMatcher.end();
            String remainingText = subText.substring(startEnd);
            Pattern endPattern = Pattern.compile(this.endText);
            Matcher endMatcher = endPattern.matcher(remainingText);
            if (endMatcher.find()) {
                int endMatcherEnd = endMatcher.end();
                endEnd = endMatcherEnd + startEnd;
            }
            token = new CommentToken(new TextRange(searchStart + startStart, searchStart + endEnd));
        }
        return token;
    }
}

