/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.action;

import com.harrand.dbwrenchgui.text.line.LineStartFinder;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.util.Exceptions;

public final class UncommentAction
extends AbstractAction {
    private final LineStartFinder lineStartFinder = new LineStartFinder();
    private final JEditorPane editorPane;
    private static final String SEARCH_TEXT = "-- ";

    public UncommentAction(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Integer> lineStarts = this.lineStartFinder.getSelectedTextLineStarts(this.editorPane);
        Collections.reverse(lineStarts);
        Document doc = this.editorPane.getDocument();
        for (Integer lineStart : lineStarts) {
            try {
                int length = SEARCH_TEXT.length();
                String subString = doc.getText(lineStart, length);
                if (!subString.equals(SEARCH_TEXT)) continue;
                doc.remove(lineStart, length);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

