/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.action;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrenchgui.text.line.LineStartFinder;
import com.harrand.dbwrenchgui.text.option.EditOptionSvr;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import org.openide.util.Exceptions;

public final class IndentAction
extends AbstractAction {
    private final LineStartFinder lineStartFinder = new LineStartFinder();
    private final JEditorPane editorPane;

    public IndentAction(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Integer> lineStarts = this.lineStartFinder.getSelectedTextLineStarts(this.editorPane);
        Collections.reverse(lineStarts);
        String indentText = IndentAction.getIndentText();
        for (Integer lineStart : lineStarts) {
            try {
                this.editorPane.getDocument().insertString(lineStart, indentText, null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static String getIndentText() {
        IOptionMgr editOptionMgr_ = EditOptionSvr.getEditOptionMgr();
        int indentLength = editOptionMgr_.getIntValue("editor.indent");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < indentLength; ++i) {
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

