/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.action;

import com.harrand.coreclasses.element.Range;
import com.harrand.dbwrenchgui.text.line.LineRangesFinder;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import org.openide.util.Exceptions;

public final class DeleteLineAction
extends AbstractAction {
    private final LineRangesFinder lineRangeFinder = new LineRangesFinder();
    private final JEditorPane editorPane;

    public DeleteLineAction(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Range> selectedLineRanges = this.lineRangeFinder.getSelectedTextLineRanges(this.editorPane);
        if (!selectedLineRanges.isEmpty()) {
            int blockStart = selectedLineRanges.get(0).getStart();
            if (blockStart > 0) {
                --blockStart;
            }
            int blockEnd = selectedLineRanges.get(selectedLineRanges.size() - 1).getEnd();
            int blockLength = blockEnd - blockStart;
            try {
                this.editorPane.getDocument().remove(blockStart, blockLength);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

