/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.template;

import com.harrand.coreclasses.dataEntry.BasicNameBuilder;
import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.INameBuilder;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.dataEntry.util.TestResultCombiner;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.dataEntry.NameBuilderPanel;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.validators.DataTypeLengthValidator;
import com.harrand.dbwrench.jdbc.validators.DataTypeScaleValidator;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.template.BasicColumnTemplate;
import com.harrand.dbwrench.template.ColumnTemplateSvr;
import com.harrand.dbwrench.template.GeneratedColumnTemplate;
import com.harrand.dbwrench.template.IColumnTemplate;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public final class ColumnTemplatePanel
extends JPanel
implements ISized,
DataEditor,
IObserver,
KeyListener,
IFocusable {
    private IColumnTemplate columnTemplate_;
    private boolean generatedFlag_ = false;
    private NameBuilderPanel builderPanel_ = null;
    private ColumnTemplateSvr templateSvr_;
    private DataTypeScaleValidator scaleValidator = new DataTypeScaleValidator();
    private DataTypeLengthValidator lengthValidator = new DataTypeLengthValidator();
    private String oldName_ = "";
    private String oldFixedNm_ = "";
    private String oldPrefix_ = "";
    private String oldSuffix_ = "";
    private List currentTemplateNms_;
    private boolean isAdd_ = false;
    private JTabbedPane tabPane_;
    private JLabel lblColGenNm_ = new JLabel("Generated Name");
    private JLabel lblColFixNm_ = new JLabel("Fixed Name");
    private JButton btnHelp_ = new JButton("Help");
    private JTextField txtColFixNm_ = new JTextField();
    private JTextField txtColGenNm_ = new JTextField();
    private JTextField txtLength_ = new JTextField("");
    private JTextField txtScale_ = new JTextField("");
    private JTextField txtDefault_ = new JTextField();
    private JTextField txtComment_ = new JTextField();
    private JLabel lblLength_ = new JLabel(ResMgr.getRes("length.label"));
    private JLabel lblScale_ = new JLabel(ResMgr.getRes("scale.label"));
    private JComboBox cboDataType_ = null;
    private JCheckBox chkIsNullable_ = new JCheckBox(App.getRes("nullable.label"));
    private JCheckBox chkAutoNumber_ = new JCheckBox(App.getRes("auto.number.label"));
    private JCheckBox chkUnsigned_ = new JCheckBox("Unsigned");
    private JCheckBox chkPk_ = new JCheckBox(App.getRes("primarykey.label"));
    private JRadioButton radFixedNm_ = new JRadioButton("Fixed Column Name");
    private JRadioButton radGenNm_ = new JRadioButton("Generated Column Name - use 'Advanced' tab");
    private ButtonGroup grpName_ = new ButtonGroup();
    private ActionListener lisAction_;
    private ActionListener lisDataType_;
    private ActionListener lisRadio_;
    public static final String TITLE = "Column Template";

    public ColumnTemplatePanel(ColumnTemplateSvr templateSvr, IColumnTemplate columnTemplate) {
        this.templateSvr_ = templateSvr;
        this.currentTemplateNms_ = new ArrayList(templateSvr.getKeys("ColumnTemplate"));
        this.columnTemplate_ = columnTemplate;
        boolean bl = this.isAdd_ = this.columnTemplate_ == null;
        if (!this.isAdd_) {
            this.oldName_ = this.columnTemplate_.getName();
        }
        if (this.columnTemplate_ instanceof GeneratedColumnTemplate) {
            this.generatedFlag_ = true;
            GeneratedColumnTemplate genTemplate = (GeneratedColumnTemplate)this.columnTemplate_;
            this.oldPrefix_ = genTemplate.getPrefix();
            this.oldSuffix_ = genTemplate.getSuffix();
        } else if (!this.isAdd_) {
            this.oldFixedNm_ = new String(this.oldName_);
        }
        this.setupGui();
    }

    public IColumnTemplate getColumnTemplate() {
        this.syncData();
        return this.columnTemplate_;
    }

    private void syncData() {
        this.generatedFlag_ = this.radGenNm_.isSelected();
        IDataType dt = this.getSelectedDataType();
        BasicColumnTemplate basicTemplate = new BasicColumnTemplate(true, "name", dt, null);
        basicTemplate.setAutoNumber(this.chkAutoNumber_.isSelected());
        basicTemplate.setIsNullable(this.chkIsNullable_.isSelected());
        basicTemplate.setIsPrimaryKey(this.chkPk_.isSelected());
        basicTemplate.setComment(this.txtComment_.getText());
        Integer length = !this.txtLength_.getText().equals("") ? new Integer(this.txtLength_.getText()) : null;
        Integer scale = !this.txtScale_.getText().equals("") ? new Integer(this.txtScale_.getText()) : null;
        basicTemplate.setLength(length);
        basicTemplate.setScale(scale);
        basicTemplate.setSigned(!this.chkUnsigned_.isSelected());
        basicTemplate.setDefault(this.txtDefault_.getText());
        if (this.generatedFlag_) {
            INameBuilder builder = this.builderPanel_.getNameBuilder();
            GeneratedColumnTemplate generatedTemplate = new GeneratedColumnTemplate(basicTemplate, builder);
            this.columnTemplate_ = generatedTemplate;
        } else {
            basicTemplate.setName(this.txtColFixNm_.getText());
            this.columnTemplate_ = basicTemplate;
        }
    }

    public boolean getUseTemplate() {
        this.syncData();
        return this.columnTemplate_.getUseTemplate();
    }

    public String getColumnName() {
        this.syncData();
        return this.columnTemplate_.getColumName();
    }

    public Column getColumn() {
        this.syncData();
        return this.columnTemplate_.getColumn();
    }

    public boolean getIsPrimaryKey() {
        return this.columnTemplate_.getIsPrimaryKey();
    }

    public ITestResult validateColumn() {
        boolean isRename;
        ITestResult inputRslt = this.validateInput();
        if (!inputRslt.getPassed()) {
            return inputRslt;
        }
        this.syncData();
        ITestResult result = this.columnTemplate_.validateColumn();
        if (result.getPassed() && this.generatedFlag_) {
            result = ((GeneratedColumnTemplate)this.columnTemplate_).validateNameBldr();
        }
        boolean bl = isRename = !this.columnTemplate_.getName().equalsIgnoreCase(this.oldName_);
        if (result.getPassed() && (this.isAdd_ || isRename) && !(result = this.checkDupNm(this.columnTemplate_.getName())).getPassed()) {
            if (this.generatedFlag_) {
                this.builderPanel_.setPrefix(this.oldPrefix_);
                this.builderPanel_.setSuffix(this.oldSuffix_);
                this.builderPanel_.syncData();
            } else {
                this.txtColFixNm_.setText(this.oldFixedNm_);
            }
        }
        return result;
    }

    private ITestResult validateInput() {
        IDataType dataType = (IDataType)this.cboDataType_.getSelectedItem();
        ITestResult lengthRslt = this.lengthValidator.isLengthValid(this.txtLength_.getText(), dataType);
        ITestResult scaleRslt = this.scaleValidator.isScaleValid(this.txtScale_.getText(), dataType);
        TestResultCombiner combiner = new TestResultCombiner();
        ITestResult combinedRslt = combiner.combineResults(lengthRslt, scaleRslt);
        return combinedRslt;
    }

    private ITestResult checkDupNm(String newNm) {
        DataEntryResult result = new DataEntryResult(true);
        Iterator it = this.currentTemplateNms_.iterator();
        while (result.getPassed() && it.hasNext()) {
            String currentNm = (String)it.next();
            if (!currentNm.equalsIgnoreCase(newNm)) continue;
            result = new DataEntryResult(false, "Duplicate Name", "A column template already exists with the name: " + newNm);
        }
        return result;
    }

    private void refresh() {
        if (this.generatedFlag_) {
            this.txtColGenNm_.setText(this.builderPanel_.getGeneratedName());
        }
        this.syncData();
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.buildListeners();
        this.addListeners();
        this.loadData();
        this.refreshNaming();
        this.updateDisplay();
    }

    private void buildControls() {
        this.cboDataType_ = new JComboBox(new Vector(BasicTypesSvr.instance().getList()));
    }

    private void layoutComponents() {
        this.buildNameBuilderPanel();
        this.tabPane_ = new JTabbedPane(3);
        this.setLayout(new BorderLayout());
        this.tabPane_.addTab("General", this.getGeneralPanel());
        this.tabPane_.addTab("Advanced", this.getGeneratedNmParamPanel());
        GuiHelper.addEmptyBorder(this);
        this.add((Component)this.tabPane_, "Center");
    }

    private JPanel getGeneralPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getNamePanel(), "North");
        panel.add((Component)this.getColumnPanel(), "Center");
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getNamePanel() {
        this.grpName_.add(this.radFixedNm_);
        this.grpName_.add(this.radGenNm_);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.getRadFixedLinePanel());
        panel.add(this.getFixedNmLinePanel());
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.getRadGenLinePanel());
        panel.add(this.getGenNmLinePanel());
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.getHelpPanel());
        GuiHelper.setTitledBorderBuffered(panel, "Column Naming");
        return panel;
    }

    private JPanel getRadFixedLinePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.radFixedNm_);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private JPanel getRadGenLinePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.radGenNm_);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private JPanel getFixedNmLinePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(25));
        panel.add(this.lblColFixNm_);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(this.txtColFixNm_);
        return panel;
    }

    private JPanel getGenNmLinePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(25));
        panel.add(this.lblColGenNm_);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(this.txtColGenNm_);
        return panel;
    }

    private JPanel getHelpPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalGlue());
        panel.add(this.btnHelp_);
        return panel;
    }

    private JPanel getGeneratedNmParamPanel() {
        JPanel panel = new JPanel();
        GuiHelper.setTitledBorderBuffered(this.builderPanel_, "Name Generation Settings");
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.builderPanel_, "North");
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private void loadData() {
        if (this.columnTemplate_ != null) {
            this.chkPk_.setSelected(this.columnTemplate_.getIsPrimaryKey());
            this.cboDataType_.setSelectedItem(DataTypeSvr.getDataType(this.columnTemplate_.getDataType().getId()));
            String lengthStr = this.columnTemplate_.getLength() != null ? this.columnTemplate_.getLength().toString() : "";
            this.txtLength_.setText(lengthStr);
            String scaleStr = this.columnTemplate_.getScale() != null ? this.columnTemplate_.getScale().toString() : "";
            this.txtScale_.setText(scaleStr);
            this.chkIsNullable_.setSelected(this.columnTemplate_.getIsNullable());
            this.chkAutoNumber_.setSelected(this.columnTemplate_.getAutoNumber());
            this.chkUnsigned_.setSelected(!this.columnTemplate_.getSigned());
            this.txtDefault_.setText(this.columnTemplate_.getDefault());
            this.txtComment_.setText(this.columnTemplate_.getComment());
            this.generatedFlag_ = this.columnTemplate_ instanceof GeneratedColumnTemplate;
            if (this.generatedFlag_) {
                this.radGenNm_.setSelected(true);
                this.txtColFixNm_.setText("");
                this.txtColGenNm_.setText(this.builderPanel_.getGeneratedName());
            } else {
                this.radFixedNm_.setSelected(true);
                String colNm = this.columnTemplate_.getColumName();
                this.txtColFixNm_.setText(colNm);
                this.txtColGenNm_.setText("");
            }
        }
    }

    private void buildNameBuilderPanel() {
        INameBuilder builder = new BasicNameBuilder("", "(TableName)", "", false);
        if (this.generatedFlag_) {
            GeneratedColumnTemplate generatedTemplate = (GeneratedColumnTemplate)this.columnTemplate_;
            builder = generatedTemplate.getNameBuilder();
        }
        this.builderPanel_ = new NameBuilderPanel(builder);
        this.builderPanel_.setEnabled(this.generatedFlag_);
        this.builderPanel_.addObserver(this);
    }

    private JPanel getColumnPanel() {
        JPanel columnPanel = new JPanel();
        columnPanel.setName("columnPanel");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        columnPanel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairFixed(new JLabel(App.getRes("data.type.label")), this.cboDataType_, gbc, columnPanel, row++);
        GuiHelper.addGridbagPair(this.lblLength_, GuiHelper.getRightGluedPanel(this.txtLength_), gbc, columnPanel, row++);
        GuiHelper.addGridbagPair(this.lblScale_, GuiHelper.getRightGluedPanel(this.txtScale_), gbc, columnPanel, row++);
        GuiHelper.addGridbagPair(new JLabel(), this.getCheckBoxPanelA(), gbc, columnPanel, row++);
        GuiHelper.addGridbagPair(new JLabel(), this.getCheckBoxPanelB(), gbc, columnPanel, row++);
        GuiHelper.addGridbagPair(new JLabel(ResMgr.getRes("default.label")), this.txtDefault_, gbc, columnPanel, row++);
        GuiHelper.addGridbagPair(new JLabel(ResMgr.getRes("comment")), this.txtComment_, gbc, columnPanel, row++);
        columnPanel.setBorder(BorderFactory.createTitledBorder(App.getRes("column.info.label")));
        GuiHelper.setTitledBorderBuffered(columnPanel, "Column Attributes");
        return columnPanel;
    }

    private JPanel getCheckBoxPanelA() {
        JPanel checkPanel = new JPanel(new GridLayout(1, 2));
        checkPanel.add(this.chkIsNullable_);
        checkPanel.add(this.chkAutoNumber_);
        return checkPanel;
    }

    private JPanel getCheckBoxPanelB() {
        JPanel checkPanel = new JPanel(new GridLayout(1, 2));
        checkPanel.add(this.chkUnsigned_);
        checkPanel.add(this.chkPk_);
        return checkPanel;
    }

    private void setCosmetics() {
        this.txtColGenNm_.setToolTipText(ResMgr.getRes("name.builder.uneditable.tooltip"));
        this.txtColGenNm_.setEditable(false);
        this.setWidthRestrictions(this.txtLength_);
        this.setWidthRestrictions(this.txtScale_);
    }

    private void setWidthRestrictions(JComponent comp) {
        comp.setMaximumSize(new Dimension(100, 1000));
        comp.setPreferredSize(new Dimension(100, 1000));
    }

    private void setNames() {
        this.radFixedNm_.setName("radFixedNm");
        this.radGenNm_.setName("radGenNm");
        this.txtColFixNm_.setName("txtColFixNm");
        this.txtColGenNm_.setName("txtColGenNm");
        this.chkPk_.setName("chkPk");
        this.chkAutoNumber_.setName("chkAutoNumber");
        this.chkIsNullable_.setName("chkIsNullable");
        this.txtDefault_.setName("txtDefault");
        this.txtComment_.setName("txtComment");
        this.txtLength_.setName("txtLength");
        this.txtScale_.setName("txtScale");
        this.cboDataType_.setName("cboDataType");
    }

    private void buildListeners() {
    }

    private void addListeners() {
        this.lisDataType_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnTemplatePanel.this.updateDisplay();
            }
        };
        this.cboDataType_.addActionListener(this.lisDataType_);
        this.lisRadio_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnTemplatePanel.this.refreshNaming();
            }
        };
        this.radFixedNm_.addActionListener(this.lisRadio_);
        this.radGenNm_.addActionListener(this.lisRadio_);
        this.btnHelp_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnTemplatePanel.this.showHelpTip();
            }
        });
    }

    private void updateDisplay() {
        this.refreshTxtLength();
        this.refreshTxtScale();
        this.refreshChkUnsigned();
    }

    public void refreshNaming() {
        this.generatedFlag_ = this.radGenNm_.isSelected();
        if (this.generatedFlag_) {
            this.radGenNm_.setSelected(true);
            this.txtColFixNm_.setText("");
            this.txtColGenNm_.setText(this.builderPanel_.getGeneratedName());
            this.lblColFixNm_.setEnabled(false);
            this.txtColFixNm_.setEnabled(false);
            this.lblColGenNm_.setEnabled(true);
            this.txtColGenNm_.setEnabled(true);
            this.builderPanel_.setEnabled(true);
        } else {
            String baseNm;
            this.radFixedNm_.setSelected(true);
            String colNm = "";
            if (!this.templateIsNull() && (colNm = this.columnTemplate_.getColumName()).indexOf(baseNm = "(TableName)") >= 0) {
                colNm = "";
            }
            this.txtColFixNm_.setText(colNm);
            this.txtColGenNm_.setText("");
            this.lblColFixNm_.setEnabled(true);
            this.txtColFixNm_.setEnabled(true);
            this.lblColGenNm_.setEnabled(false);
            this.txtColGenNm_.setEnabled(false);
            this.builderPanel_.setEnabled(false);
        }
    }

    public void refreshTxtLength() {
        IDataType dataType;
        boolean used = this.getLengthUsed();
        this.txtLength_.setEnabled(used);
        this.lblLength_.setEnabled(used);
        if (!used) {
            this.txtLength_.setText("");
        }
        String toolTip = (dataType = this.getSelectedDataType()) != null ? dataType.getLengthUnitsDesc() : "";
        this.txtLength_.setToolTipText(toolTip);
    }

    public void refreshTxtScale() {
        IDataType dataType;
        boolean used = this.getScaleUsed();
        this.txtScale_.setEnabled(used);
        this.lblScale_.setEnabled(used);
        if (!used) {
            this.txtScale_.setText("");
        }
        String toolTip = (dataType = this.getSelectedDataType()) != null ? dataType.getScaleUnitsDesc() : "";
        this.txtScale_.setToolTipText(toolTip);
    }

    public void refreshChkUnsigned() {
        boolean used = this.getUnsignedUsed();
        this.chkUnsigned_.setEnabled(used);
        if (!used) {
            this.chkUnsigned_.setSelected(false);
        }
    }

    public boolean getLengthUsed() {
        IDataType dataType = this.getSelectedDataType();
        boolean used = dataType != null ? dataType.isLengthUsed() : false;
        return used;
    }

    public boolean getUnsignedUsed() {
        IDataType dataType = this.getSelectedDataType();
        boolean used = dataType != null && dataType.isNumberLikeType();
        return used;
    }

    public boolean getScaleUsed() {
        IDataType dataType = this.getSelectedDataType();
        boolean used = dataType != null ? dataType.isScaleUsed() : false;
        return used;
    }

    private IDataType getSelectedDataType() {
        return (IDataType)this.cboDataType_.getSelectedItem();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(10, 10, 410, 580);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    private boolean templateIsNull() {
        return this.columnTemplate_ == null;
    }

    private void showHelpTip() {
        String title = "Column Template Naming Help";
        String msg = "Fixed Names: \nUsed for columns that will have the same name in many tables. \n\nGenerated Names: \nUsed for columns where the column name contains the table name. \nExamples of such columns are 'Id' columns, which may have a name \nbased on pattern like '(TableName)_Id'.";
        GuiMessageHelper.showOptionPaneMsg(null, title, msg, 1);
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.refresh();
    }

    @Override
    public void transferFocus() {
        this.radFixedNm_.requestFocus();
    }

    @Override
    public Collector getCollector() {
        return this.templateSvr_;
    }

    @Override
    public Identifiable getDataObject() {
        return (Identifiable)((Object)this.getColumnTemplate());
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    @Override
    public ITestResult validateData() {
        return this.validateColumn();
    }
}

