/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.template;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.prompt.PromptCollectionAdd;
import com.harrand.coregui.command.prompt.PromptCollectionRemove;
import com.harrand.coregui.command.prompt.PromptCollectionUpdate;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.list.CheckList;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.coregui.panel.UpDownPanel;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.template.BasicColumnTemplate;
import com.harrand.dbwrench.template.ColumnTemplateSvr;
import com.harrand.dbwrench.template.IColumnTemplate;
import com.harrand.dbwrenchgui.template.ColumnTemplatePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListModel;

public class ColumnTemplateListPanel
extends JPanel
implements ISized,
IObserver {
    private CheckList checkList_ = new CheckList();
    private ColumnTemplateSvr templateSrv_;
    private IOptionMgr dbOptionMgr_ = null;
    private JDialog parentDlg_;
    private UpDownPanel upDownPanel_;
    private HeaderPanel header_;
    private int gap_;
    private JButton btnAdd_ = new JButton("Add");
    private JButton btnEdit_ = new JButton("Edit");
    private JButton btnDelete_ = new JButton("Delete");
    private JTextPane txtTemplatesDesc_ = new JTextPane();
    private ActionListener lisUp_;
    private ActionListener lisDown_;
    private ActionListener lisAdd_;
    private ActionListener lisEdit_;
    private ActionListener lisDelete_;
    private ActionListener lisCheckBox_;
    private ITestResult result_;
    private CommandChain cmdChain_;

    public ColumnTemplateListPanel(ColumnTemplateSvr templateSrv) {
        this.templateSrv_ = templateSrv;
        this.gap_ = 5;
        this.setupGui();
        this.cmdChain_ = App.getCommandChain();
        this.templateSrv_.addObserver(this);
    }

    private void setupGui() {
        this.createControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.buildListeners();
    }

    private void createControls() {
        this.updateCheckList();
        this.header_ = new HeaderPanel("Column Templates", 5, false);
        this.txtTemplatesDesc_.setText("Column templates are used to automatically add common columns to tables when they are created.");
    }

    private void updateCheckList() {
        NamedList columnTemplates = this.templateSrv_.getTemplates();
        Object[] checkBoxes = new Object[columnTemplates.size()];
        Iterator it = columnTemplates.iterator();
        int i = 0;
        while (it.hasNext()) {
            BasicColumnTemplate template = (BasicColumnTemplate)it.next();
            JCheckBox checkBox = new JCheckBox(template.getDisplayText());
            checkBox.setName(template.getName());
            checkBoxes[i] = checkBox;
            checkBox.setSelected(template.getUseTemplate());
            ++i;
        }
        this.checkList_.setListData(checkBoxes);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(5 * this.gap_, this.gap_));
        this.add((Component)this.header_, "North");
        this.add((Component)this.getListUpDownPanel(), "Center");
        this.add((Component)this.getBtnPanel(), "East");
    }

    private JPanel getListUpDownPanel() {
        this.upDownPanel_ = new UpDownPanel();
        JPanel panel = new JPanel(new BorderLayout(this.gap_, this.gap_));
        panel.add((Component)this.txtTemplatesDesc_, "North");
        panel.add((Component)new JScrollPane(this.checkList_), "Center");
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        Dimension gap = new Dimension(0, 5);
        panel.add(this.btnAdd_);
        panel.add(Box.createRigidArea(gap));
        panel.add(this.btnEdit_);
        panel.add(Box.createRigidArea(gap));
        panel.add(this.btnDelete_);
        panel.add(Box.createRigidArea(gap));
        panel.add(Box.createRigidArea(gap));
        panel.add(this.upDownPanel_);
        panel.add(Box.createVerticalGlue());
        int EDGE = 4;
        panel.setBorder(GuiHelper.getEmptyBorder());
        return panel;
    }

    private void setCosmetics() {
        this.sizeButtons();
        Color panColor = this.getBackground();
        Color panColorDup = new Color(panColor.getRed(), panColor.getGreen(), panColor.getBlue());
        this.txtTemplatesDesc_.setBackground(panColorDup);
        this.txtTemplatesDesc_.setEditable(false);
        this.txtTemplatesDesc_.setForeground(Color.BLACK);
        this.btnAdd_.setToolTipText("Add new column template");
        this.btnEdit_.setToolTipText("Edit selected column template");
        this.btnDelete_.setToolTipText("Delete selected column template");
        this.btnAdd_.setMnemonic('A');
        this.btnEdit_.setMnemonic('E');
        this.btnDelete_.setMnemonic('D');
    }

    private void sizeButtons() {
        Dimension commonSize = this.upDownPanel_.getUpDownButtonMaxSize();
        this.btnAdd_.setMaximumSize(commonSize);
        this.btnEdit_.setMaximumSize(commonSize);
        this.btnDelete_.setMaximumSize(commonSize);
        this.upDownPanel_.setButtonMaxSize(commonSize);
    }

    private void setNames() {
        this.checkList_.setName("checkList");
        this.upDownPanel_.setName("upDownPanel");
        this.btnAdd_.setName("btnAdd");
        this.btnEdit_.setName("btnEdit");
        this.btnDelete_.setName("btnDelete");
    }

    private void buildListeners() {
        this.lisUp_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnTemplateListPanel.this.moveUp();
            }
        };
        this.upDownPanel_.setUpListener(this.lisUp_);
        this.lisDown_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnTemplateListPanel.this.moveDown();
            }
        };
        this.upDownPanel_.setDownListener(this.lisDown_);
        this.lisAdd_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnTemplateListPanel.this.addTemplate();
            }
        };
        this.btnAdd_.addActionListener(this.lisAdd_);
        this.lisEdit_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnTemplateListPanel.this.editTemplate();
            }
        };
        this.btnEdit_.addActionListener(this.lisEdit_);
        this.lisDelete_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnTemplateListPanel.this.deleteTemplate();
            }
        };
        this.btnDelete_.addActionListener(this.lisDelete_);
        this.checkList_.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() == 1 && ColumnTemplateListPanel.this.checkValidSelection()) {
                    ColumnTemplateListPanel.this.updateUseSettings(null);
                }
                if (me.getClickCount() == 2 && ColumnTemplateListPanel.this.checkValidSelection()) {
                    ColumnTemplateListPanel.this.editTemplate();
                }
            }
        });
    }

    private boolean checkValidSelection() {
        int selectIdx = this.checkList_.getSelectedIndex();
        if (selectIdx < 0) {
            GuiMessageHelper.showInputErrMsg(null, "Invalid Selection", "A column template must be selected");
            return false;
        }
        return true;
    }

    private void moveUp() {
        int selectIdx = this.checkList_.getSelectedIndex();
        if (!this.checkValidSelection()) {
            return;
        }
        BasicColumnTemplate template = this.getSelectedTemplate();
        this.result_ = this.templateSrv_.moveUp(template);
        this.checkMovePassed();
        this.updateCheckList();
        if (this.result_.getPassed()) {
            this.checkList_.setSelectedIndex(selectIdx - 1);
        }
    }

    private void moveDown() {
        int selectIdx = this.checkList_.getSelectedIndex();
        if (!this.checkValidSelection()) {
            return;
        }
        BasicColumnTemplate template = this.getSelectedTemplate();
        boolean include = template.getUseTemplate();
        this.result_ = this.templateSrv_.moveDown(template);
        this.checkMovePassed();
        this.updateCheckList();
        if (this.result_.getPassed()) {
            this.checkList_.setSelectedIndex(selectIdx + 1);
        }
    }

    private BasicColumnTemplate getSelectedTemplate() {
        NamedList colTemplates = this.templateSrv_.getTemplates();
        int selectIdx = this.checkList_.getSelectedIndex();
        BasicColumnTemplate template = (BasicColumnTemplate)colTemplates.get(selectIdx);
        return template;
    }

    private void checkMovePassed() {
        if (!this.result_.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, this.result_);
        }
    }

    private void addTemplate() {
        ColumnTemplatePanel templatePanel = new ColumnTemplatePanel(this.templateSrv_, null);
        PromptCollectionAdd cmd = new PromptCollectionAdd(this.templateSrv_, "ColumnTemplate", templatePanel);
        cmd.setCommandChain(this.cmdChain_);
        cmd.actionPerformed(null);
        this.updateCheckList();
    }

    private void editTemplate() {
        if (!this.checkValidSelection()) {
            return;
        }
        BasicColumnTemplate template = this.getSelectedTemplate();
        ColumnTemplatePanel templatePanel = new ColumnTemplatePanel(this.templateSrv_, template);
        PromptCollectionUpdate cmd = new PromptCollectionUpdate(this.templateSrv_, template, templatePanel);
        cmd.setCommandChain(this.cmdChain_);
        cmd.actionPerformed(null);
        this.updateCheckList();
    }

    private void deleteTemplate() {
        if (!this.checkValidSelection()) {
            return;
        }
        BasicColumnTemplate template = this.getSelectedTemplate();
        PromptCollectionRemove cmd = new PromptCollectionRemove(this.templateSrv_, "ColumnTemplate", template.getName());
        cmd.actionPerformed(null);
        this.updateCheckList();
    }

    private void updateUseSettings(ActionEvent e) {
        NamedList colTemplates = this.templateSrv_.getTemplates();
        ListModel model = this.checkList_.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckBox chkBox = (JCheckBox)model.getElementAt(i);
            boolean isSelected = chkBox.isSelected();
            IColumnTemplate template = (IColumnTemplate)colTemplates.get(i);
            template.setUseTemplate(isSelected);
        }
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(420, 280);
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateCheckList();
    }
}

