/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table.query;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.db.name.DbDisplayNmSvr;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DbQueryTableDriver
implements ITableDriver {
    private Database db;
    private String className;

    public DbQueryTableDriver(Database db) {
        this.db = db;
        this.className = CustomType.getClassName();
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.db.size(this.className)][this.getHeaders().length];
        int row = 0;
        for (CustomType type : this.db.values(this.className)) {
            int col = 0;
            matrix[row][col++] = new Integer(type.getId());
            matrix[row][col++] = type.getName();
            matrix[row][col++] = type.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Int Id", "Name", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Int Id");
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Int Id");
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        Integer idInt = (Integer)data.get("Int Id");
        String nm = (String)data.get("Name");
        DbQuery query = new DbQuery(nm);
        return query;
    }

    @Override
    public Collector getCollector() {
        return this.db;
    }

    @Override
    public String getIdfClassName() {
        return this.className;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return null;
    }

    @Override
    public String getDisplayName() {
        return new DbDisplayNmSvr().getDisplayName(this.className);
    }

    @Override
    public String getDisplayPlural() {
        return new DbDisplayNmSvr().getDisplayPlural(this.className);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

