/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Zone;
import com.harrand.sketch.panel.ZoneEditPanel;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZoneTableDriver
implements ITableDriver {
    private Diagram diagram_;
    private String className_ = Zone.getClassName();

    public ZoneTableDriver(Diagram diagram) {
        this.diagram_ = diagram;
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.diagram_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Zone note : this.diagram_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = note.getName();
            matrix[row][col++] = note.getText();
            matrix[row][col++] = note.getName();
            matrix[row][col++] = note.getBounds().x;
            matrix[row][col++] = note.getBounds().y;
            matrix[row][col++] = note.getBounds().width;
            matrix[row][col++] = note.getBounds().height;
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Text", "ID", "X", "Y", "W", "H"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Text");
        list.add("ID");
        list.add("X");
        list.add("Y");
        list.add("W");
        list.add("H");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Text");
        list.add("ID");
        list.add("X");
        list.add("Y");
        list.add("W");
        list.add("H");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        Zone newZone = null;
        String nm = (String)data.get("Name");
        String text = (String)data.get("Text");
        int x = (Integer)data.get("X");
        int y = (Integer)data.get("Y");
        int width = (Integer)data.get("W");
        int height = (Integer)data.get("H");
        Rectangle bounds = new Rectangle(x, y, width, height);
        newZone = new Zone(nm, text, bounds);
        return newZone;
    }

    @Override
    public Collector getCollector() {
        return this.diagram_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        if (currentIdf != null) {
            return new ZoneEditPanel((Zone)currentIdf, this.diagram_);
        }
        return new ZoneEditPanel(null, this.diagram_);
    }

    @Override
    public String getDisplayName() {
        return this.diagram_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.diagram_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

