/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import com.harrand.dbwrenchgui.panel.SchemaEditPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;

    public SchemaTableDriver(Database db) {
        this.collector_ = db;
        this.className_ = Schema.getClassName();
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Schema schema : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = schema.getName();
            matrix[row][col++] = schema.getComment();
            matrix[row][col++] = schema.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Comment", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        String oldNm = (String)data.get("ID");
        Database db = (Database)this.collector_;
        String newNm = (String)data.get("Name");
        String newCmm = (String)data.get("Comment");
        Schema schOld = db.getSchema(oldNm);
        ITestResult result = Schema.checkName(newNm);
        if (!result.getPassed()) {
            throw new Exception(result.getDetail());
        }
        if (!oldNm.equals(newNm)) {
            SqlReservedWordGui.instance().warnIfReserved(newNm);
        }
        if (!newNm.equals(oldNm)) {
            ITestResult dupRslt;
            ITestResult iTestResult = dupRslt = oldNm.equalsIgnoreCase(newNm) ? new DataEntryResult(true) : db.checkDuplicateName(Schema.getClassName(), newNm);
            if (dupRslt.getPassed()) {
                RenameIdf cmd = new RenameIdf(db, schOld, oldNm, newNm, App.getCommandChain());
                cmd.setRenameMgr(db.getRenameMgr());
                cmd.actionPerformed(new ActionEvent(this, 0, ""));
            } else {
                GuiMessageHelper.showInputErrMsg(null, dupRslt);
            }
        }
        if (!newCmm.equals(schOld.getComment())) {
            schOld.setComment(newCmm);
        }
        return schOld;
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        if (currentIdf != null) {
            return new SchemaEditPanel((Schema)currentIdf);
        }
        return new SchemaEditPanel((Database)this.collector_);
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

