/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.panel.ProcEditPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ProcTableDriver
implements ITableDriver {
    private Schema schema_;
    private String className_;

    public ProcTableDriver(Schema schema) {
        this.schema_ = schema;
        this.className_ = Proc.getClassName();
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.schema_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Proc proc : this.schema_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = proc.getName();
            matrix[row][col++] = proc.getSrc();
            matrix[row][col++] = proc.getComment();
            matrix[row][col++] = proc.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Src", "Comment", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Src");
        list.add("Name");
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Src");
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        Proc newProc = null;
        newProc = new Proc((String)data.get("Src"), (String)data.get("Comment"), (String)data.get("Name"));
        return newProc;
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        if (currentIdf != null) {
            return new ProcEditPanel((Proc)currentIdf);
        }
        return new ProcEditPanel(this.schema_);
    }

    @Override
    public String getDisplayName() {
        return this.schema_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        String schPrefix = this.schema_.getDbHasManySchemas() ? this.schema_.getName() + " " : "";
        return schPrefix + this.schema_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

