/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.panel.JdbcConfigEditPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JdbcConfigTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    public JdbcConfigTableDriver(DbUser user) {
        this.collector_ = user;
        this.className_ = JdbcConfig.clazz();
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (JdbcConfig config : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = config.getName();
            matrix[row][col++] = config.getDbms().getName();
            matrix[row][col++] = config.getServer();
            matrix[row][col++] = config.getObjectInstanceName();
            matrix[row][col++] = config.getUserName();
            matrix[row][col++] = config.getDsn();
            matrix[row][col++] = config.getPassword();
            matrix[row][col++] = config.getDriverClassName();
            matrix[row][col++] = new Integer(config.getPort());
            matrix[row][col++] = config.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "DBMS", "Server", "Database", "User Name", "Dsn", "Password", "Driver", "Port", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        List list = this.getHiddenColumns();
        list.add("DBMS");
        list.add("Dsn");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Name");
        list.add("Password");
        list.add("Port");
        list.add("ID");
        list.add("Driver");
        list.add("Dsn");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) {
        Object obj = data.get("DBMS");
        String dbmsName = null;
        if (obj instanceof String) {
            dbmsName = (String)data.get("DBMS");
        } else if (obj instanceof Dbms) {
            dbmsName = ((Dbms)obj).getName();
        } else {
            StrHelper.throwProgrammingException("Object not String or Dbms");
        }
        return new JdbcConfig(dbmsName, (String)data.get("Server"), (String)data.get("Database"), (String)data.get("Dsn"), (String)data.get("User Name"), (String)data.get("Password"), (Integer)data.get("Port"), (String)data.get("Driver"));
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return new JdbcConfigEditPanel((JdbcConfig)currentIdf);
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        HashMap map = new HashMap();
        return map;
    }

    @Override
    public Map getCustomCellEditors() {
        HashMap map = new HashMap();
        return map;
    }
}

