/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ForeignKeyTableDriver
implements ITableDriver {
    private String className_ = ForeignKey.getClassName();
    private Table table_;
    private Integer relationIdObj_;
    private static final String HD_COLUMNS = "Columns";

    public ForeignKeyTableDriver(Table table, Integer relationIdObj) {
        this.table_ = table;
        this.relationIdObj_ = relationIdObj;
    }

    public void setCollector(Collector coll) {
        this.table_ = (Table)coll;
    }

    @Override
    public Object[][] getDataMatrix() {
        List fks;
        if (this.table_ == null || this.relationIdObj_ == null) {
            fks = new ArrayList();
        } else {
            Database db = this.table_.getSchema().getDb();
            fks = db.getFkUtil().getFksForTable(this.table_, this.relationIdObj_);
        }
        return this.getDataMatrixCore(fks);
    }

    private Object[][] getDataMatrixCore(List fks) {
        Object[][] matrix = new Object[fks.size()][this.getHeaders().length];
        int row = 0;
        for (ForeignKey fk : fks) {
            int col = 0;
            matrix[row][col++] = fk.getName();
            matrix[row][col++] = fk.getComment();
            matrix[row][col++] = fk.getKeyDescr();
            matrix[row][col++] = fk.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Comment", HD_COLUMNS, "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(HD_COLUMNS);
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        ForeignKey newFk = null;
        ForeignKey oldFk = this.table_.getForeignKey((String)data.get("ID"));
        newFk = new ForeignKey((String)data.get("Name"), oldFk.getParTbl(), oldFk.getChdTbl(), oldFk.getColumns(), oldFk.getDeleteActionId(), oldFk.getUpdateActionId(), (String)data.get("Comment"), oldFk.getChildCardinality(), oldFk.getParentLinkColNm());
        return newFk;
    }

    @Override
    public Collector getCollector() {
        return this.table_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        ForeignKey currentFk = (ForeignKey)currentIdf;
        Database db = this.table_.getSchema().getDb();
        ForeignKeyPanel panel = new ForeignKeyPanel((ForeignKey)currentIdf, db);
        if (this.relationIdObj_ == 1) {
            panel.setChildTable(this.table_);
        } else {
            panel.setParentTable(this.table_);
        }
        return panel;
    }

    @Override
    public String getDisplayName() {
        return this.table_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.table_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

