/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.diagram.DiagramEditPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DiagramTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;

    public DiagramTableDriver(Collector collector) {
        this.collector_ = collector;
        this.className_ = Diagram.getClassName();
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Diagram diagram : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = diagram.getName();
            matrix[row][col++] = diagram.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        return this.getUneditableColumns();
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        Diagram newDiagram = null;
        Diagram oldDiagram = (Diagram)this.collector_.get(this.className_, (String)data.get("ID"));
        RenderConfig config = oldDiagram.getRenderConfig();
        String newNm = (String)data.get("Name");
        ITestResult result = Diagram.checkValues(newNm);
        if (!result.getPassed()) {
            throw new Exception(result.getDetail());
        }
        newDiagram = new Diagram(newNm, config, oldDiagram.getOnlyGlyphs());
        return newDiagram;
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        DiagramEditPanel editor = null;
        if (currentIdf == null) {
            editor = DiagramEditPanel.getInstance();
            editor.setItems(null, (Database)this.collector_);
            DbUser user = App.getUser();
            if (user != null) {
                String key = "diagram.option.mgr";
                editor.setOptionMgr(user.getOptionMgr(key));
            }
        }
        return editor;
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

