/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrenchgui.panel.CustomTypePanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomTypeTableDriver
implements ITableDriver {
    private Schema schema_;
    private String className_;

    public CustomTypeTableDriver(Schema schema) {
        this.schema_ = schema;
        this.className_ = CustomType.getClassName();
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.schema_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (CustomType type : this.schema_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = new Integer(type.getId());
            matrix[row][col++] = type.getName();
            matrix[row][col++] = type.getNotes();
            matrix[row][col++] = type.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Int Id", "Name", "Notes", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Int Id");
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Int Id");
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        Integer idInt = (Integer)data.get("Int Id");
        String nm = (String)data.get("Name");
        String notes = (String)data.get("Notes");
        CustomType type = new CustomType(idInt, nm, notes);
        return type;
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        if (currentIdf != null) {
            return new CustomTypePanel((CustomType)currentIdf, false);
        }
        return new CustomTypePanel(this.schema_);
    }

    @Override
    public String getDisplayName() {
        return this.schema_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        String schPrefix = this.schema_.getDbHasManySchemas() ? this.schema_.getName() + " " : "";
        return schPrefix + this.schema_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

