/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataConversion.abstractions.IDataConversion;
import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.dataConversion.DbDataConversion;
import com.harrand.dbwrenchgui.panel.DbDataConversionEditPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ConversionTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;

    public String HD_CONVERSION_VALUE() {
        return "Conversion Value";
    }

    public ConversionTableDriver(Collector collector, String objectClassName) {
        this.collector_ = collector;
        this.className_ = objectClassName;
    }

    public void addObserver(IObserver observer) {
        if (this.collector_ instanceof IObservable) {
            ((IObservable)((Object)this.collector_)).addObserver(observer);
        }
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (IDataConversion conversion : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = conversion.getName();
            matrix[row][col++] = conversion.getConversionValue();
            matrix[row][col++] = conversion.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", this.HD_CONVERSION_VALUE(), "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Name");
        return list;
    }

    @Override
    public Identifiable buildObject(Map data) {
        String id = (String)data.get("Name");
        DbDataConversion oldConversion = (DbDataConversion)this.collector_.get(this.getIdfClassName(), id);
        String conversionValue = (String)data.get(this.HD_CONVERSION_VALUE());
        DbDataConversion newConversion = new DbDataConversion(oldConversion.getConvertedObject(), (Collector)oldConversion.getCollector(), oldConversion.getParent(), conversionValue);
        return newConversion;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        DbDataConversion dataConversion = (DbDataConversion)currentIdf;
        return new DbDataConversionEditPanel(dataConversion);
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

