/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.IRenameMgrSource;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.dbwrench.command.bldr.column.SetPkCmdBldr;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import com.harrand.dbwrenchgui.panel.ColumnEditPanel;
import com.harrand.dbwrenchgui.table.PkIconTableCellRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ColumnTableDriver
implements ITableDriver,
IRenameMgrSource {
    private Collector collector_;
    private String tableName_;
    private String className_;
    private PrimaryKey pk_;
    private List fkColumnNames_;
    private SwingThemeCtrl themeCtrl_;

    public ColumnTableDriver(Table table) {
        this.setCollector(table);
        this.className_ = Column.getClassName();
        this.themeCtrl_ = App.getThemeCtrl();
        this.refreshPk();
    }

    private void checkInput(Collector collector) throws IllegalArgumentException {
        if (collector == null) {
            StrHelper.throwProgrammingException("ColumnTableDriver constructor can not be passed a NULL collector.");
        }
    }

    public void setCollector(Collector collector) {
        this.checkInput(collector);
        this.collector_ = collector;
        this.tableName_ = collector != null ? collector.getName() : "";
    }

    @Override
    public Object[][] getDataMatrix() {
        this.refreshPk();
        this.refreshFkColumnNames();
        int itemCount = this.collector_.size(this.className_);
        Object[][] matrix = new Object[itemCount][this.getHeaders().length];
        int row = 0;
        for (Column column : this.collector_.values(this.className_)) {
            String name = column.getName();
            int col = 0;
            matrix[row][col++] = new Boolean(this.isPkField(name));
            matrix[row][col++] = name;
            matrix[row][col++] = column.getDataTypeAndLength();
            matrix[row][col++] = column.getDataType().getName();
            matrix[row][col++] = column.getLength();
            matrix[row][col++] = new Boolean(column.getIsNullable());
            matrix[row][col++] = new Boolean(column.getAutoNumber());
            matrix[row][col++] = column.getComment();
            matrix[row][col++] = column.getDefault();
            matrix[row][col++] = new Boolean(!column.getSignedFlag());
            matrix[row][col++] = new Boolean(column.getUnique());
            matrix[row][col++] = column.getScale();
            matrix[row][col++] = column.getEnumCsv();
            matrix[row][col++] = new Boolean(this.isFkField(name));
            matrix[row][col++] = this.getBackColor(name);
            matrix[row][col++] = name;
            ++row;
        }
        return matrix;
    }

    private boolean isPkField(String columnName) {
        Table table = (Table)this.collector_;
        Column column = table.getColumn(columnName);
        return column.isPkField(table);
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{PrimaryKey.getClassAbbr(), "Name", "Type", "Data Type", "Length", "Nulls", "Auto Num.", "Comment", "Default", "Unsigned", "Unique", "Scale", "ENUM Values", "FK", "BkColor", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        list.add("Type");
        list.add("Data Type");
        list.add("Length");
        list.add("Scale");
        list.add("FK");
        list.add("Unsigned");
        list.add("ENUM Values");
        list.add("BkColor");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("BkColor");
        list.add("Data Type");
        list.add("Length");
        list.add("Scale");
        list.add("ENUM Values");
        list.add("ID");
        return list;
    }

    private void refreshFkColumnNames() {
        this.fkColumnNames_ = ((Table)this.collector_).getFkColNames();
    }

    private String getFkField(String name) {
        String fkStr = "";
        if (this.isFkField(name)) {
            fkStr = "FK";
        }
        return fkStr;
    }

    private boolean isFkField(String fieldName) {
        return this.fkColumnNames_.contains(fieldName);
    }

    private Color getBackColor(String fieldName) {
        Color color = Color.WHITE;
        if (this.getFkField(fieldName).length() > 0) {
            color = Colors.getBlueLight();
        }
        if (this.isPkField(fieldName)) {
            color = Colors.getYellowSoft();
        }
        return color;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        int dataTypeId;
        Object obj;
        String id = (String)data.get("ID");
        Column oldColumn = (Column)this.collector_.get(this.className_, id);
        Column newColumn = null;
        boolean pkSelected = (Boolean)data.get(PrimaryKey.getClassAbbr());
        String name = (String)data.get("Name");
        String oldName = oldColumn.getName();
        if (!oldName.equals(name)) {
            SqlReservedWordGui.instance().warnIfReserved(name);
        }
        if ((obj = data.get("Data Type")) instanceof String) {
            String dataTypeDesc = (String)data.get("Data Type");
            dataTypeId = this.getDataTypeId(dataTypeDesc);
        } else {
            DataType dataType = (DataType)data.get("Data Type");
            dataTypeId = dataType.getId();
        }
        boolean nullable = (Boolean)data.get("Nulls");
        String commentStr = (String)data.get("Comment");
        String defaultStr = (String)data.get("Default");
        boolean autoNumber = (Boolean)data.get("Auto Num.");
        boolean unique = (Boolean)data.get("Unique");
        Integer length = (Integer)data.get("Length");
        Integer scale = (Integer)data.get("Scale");
        boolean signed = (Boolean)data.get("Unsigned") == false;
        String enumCsv = (String)data.get("ENUM Values");
        newColumn = new Column(name, dataTypeId, length, nullable, autoNumber, defaultStr, scale, commentStr, signed, enumCsv);
        newColumn.setUnique(unique);
        newColumn.setIsArray(oldColumn.getIsArray());
        this.updatePkDisp(id, pkSelected);
        return newColumn;
    }

    private int getDataTypeId(String dtNm) {
        Table tbl = (Table)this.getCollector();
        Schema sch = tbl.getSchema();
        Database db = sch.getDb();
        IDataType type = DataTypeSvr.getDataType(db, sch, dtNm);
        return type.getId();
    }

    private void updatePkDisp(String oldColName, boolean pkSelected) throws Exception {
        this.refreshPk();
        boolean oldPkSelected = this.isPkField(oldColName);
        if (pkSelected != oldPkSelected) {
            this.updatePk(oldColName);
        }
    }

    private void updatePk(String colName) {
        Table table = (Table)this.collector_;
        Column col = table.getColumn(colName);
        SetPkCmdBldr cmdBldr = new SetPkCmdBldr();
        Command cmd = cmdBldr.getCommand(table, col);
        cmd.actionPerformed(null);
    }

    private void refreshPk() {
        this.pk_ = ((Table)this.collector_).getPrimaryKey();
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return new ColumnEditPanel((Column)currentIdf, (Table)this.collector_);
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellEditors() {
        HashMap map = new HashMap();
        return map;
    }

    @Override
    public Map getCustomCellRenderers() {
        HashMap<String, PkIconTableCellRenderer> map = new HashMap<String, PkIconTableCellRenderer>();
        String[] objs = BasicTypesSvr.instance().getStringArray();
        Table table = (Table)this.collector_;
        PkIconTableCellRenderer pkIconRenderer = new PkIconTableCellRenderer(table);
        map.put(PrimaryKey.getClassAbbr(), pkIconRenderer);
        return map;
    }

    @Override
    public RenameMgr getRenameMgr() {
        Table tbl = (Table)this.collector_;
        return tbl.getSchema().getDb().getRenameMgr();
    }
}

