/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.sub.editor;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.option.UserOptionMgr;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.text.completion.popupMenu.CodeCompletionItem;
import com.harrand.dbwrenchgui.text.completion.popupMenu.CurrentWordFinder;
import com.harrand.dbwrenchgui.text.completion.popupMenu.ShowCodeCompletePopupAction;
import com.harrand.dbwrenchgui.text.keystroke.CodeCompleteRePopUpCtrl;
import com.harrand.dbwrenchnb.editor.completion.CodeCompletionItemBldr;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.Timer;

public final class TimedCodeCompleteDisplayer {
    private final CurrentWordFinder currentWordFinder = new CurrentWordFinder();
    private JEditorPane editorPane;
    private static final int POPUP_DELAY = 50;
    private final CodeCompletionItemBldr codeCompletionItemBldr = new CodeCompletionItemBldr();

    public void checkShowCodeComplete(JEditorPane editorPane, CodeCompleteRePopUpCtrl codeCompleteRePopUpCtrl) {
        this.editorPane = editorPane;
        if (!this.isOptionEnabled() || !this.showCodeComplete()) {
            return;
        }
        this.startTimer(editorPane, codeCompleteRePopUpCtrl);
    }

    private boolean isOptionEnabled() {
        DbUser user = App.getUser();
        UserOptionMgr editOptMgr = (UserOptionMgr)user.getOptionMgr("editor.option.mgr");
        boolean enabled = editOptMgr.getBoolValue("auto.show.code.completions");
        return enabled;
    }

    private void startTimer(final JEditorPane editorPane1, final CodeCompleteRePopUpCtrl codeCompleteRePopUpCtrl) {
        Timer timer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((Timer)evt.getSource()).stop();
                ShowCodeCompletePopupAction action = new ShowCodeCompletePopupAction(editorPane1, codeCompleteRePopUpCtrl);
                action.actionPerformed(null);
            }
        });
        timer.setInitialDelay(50);
        timer.start();
    }

    private boolean showCodeComplete() {
        boolean dotTyped;
        String currentWord = this.currentWordFinder.getCurrentWord(this.getEditorText(), this.editorPane.getCaretPosition());
        String currentPhrase = this.currentWordFinder.getCurrentPhrase(this.getEditorText(), this.editorPane.getCaretPosition());
        boolean isMinimumLength = currentWord != null && currentWord.length() > 1;
        boolean bl = dotTyped = currentPhrase != null && currentPhrase.contains(".");
        if (isMinimumLength || dotTyped) {
            List<CodeCompletionItem> codeCompletionItems = this.codeCompletionItemBldr.getCodeCompletionItems(currentWord, currentPhrase);
            return !this.isCurrentWordOnlyCodeCompletion(codeCompletionItems, currentWord);
        }
        return false;
    }

    private boolean isCurrentWordOnlyCodeCompletion(List<CodeCompletionItem> codeCompletionItems, String currentWord) {
        CodeCompletionItem codeCompletionItem;
        String codeCompletionText;
        return codeCompletionItems.size() == 1 && (codeCompletionText = (codeCompletionItem = codeCompletionItems.get(0)).getText()).equalsIgnoreCase(currentWord);
    }

    private String getEditorText() {
        return GuiHelper.getEditorPaneText(this.editorPane);
    }
}

