/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.sub.editor;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.dbwrenchgui.sub.editor.ICommandExecutor;
import com.harrand.dbwrenchgui.sub.editor.TimedCodeCompleteDisplayer;
import com.harrand.dbwrenchgui.sub.editor.key.DbwEditorKeyListener;
import com.harrand.dbwrenchgui.sub.editor.key.KeyStrokeActionCtrl;
import com.harrand.dbwrenchgui.text.action.EditorColorCodeAction;
import com.harrand.dbwrenchgui.text.keystroke.CodeCompleteRePopUpCtrl;
import com.harrand.dbwrenchgui.text.keystroke.DbwEditorKeyStrokeMapper;
import com.harrand.dbwrenchgui.text.undo.UndoableEditListenerImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

public final class DbwEditor
extends JPanel
implements IObservable,
MouseListener,
KeyListener {
    private final JEditorPane editorPane = new JTextPane();
    private final JScrollPane scrollPane = new JScrollPane(this.editorPane);
    private final Document doc = this.editorPane.getDocument();
    private final IObservable observable_ = new BasicObservable();
    private final UndoableEditListenerImpl undoableEditListener = new UndoableEditListenerImpl();
    private final EditorFocusListener editorFocusListener = new EditorFocusListener();
    private final TimedCodeCompleteDisplayer timedCodeCompleteDisplayer = new TimedCodeCompleteDisplayer();
    private ICommandExecutor commandExecutor;
    private final EditorColorCodeAction editorColorCodeAction;
    private DbwEditorKeyListener keyListener;
    public static final int MAX_LENGTH_FOR_COLOR_CODING = 30000;

    public DbwEditor() {
        this.disableDefaultKeys();
        int fontSize = OsUtil.isMacOs() ? 13 : 12;
        String fontName = OsUtil.isMacOs() ? "Monospaced" : "Courier New";
        this.editorPane.setFont(new Font(fontName, 0, fontSize));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.doc.addUndoableEditListener(this.undoableEditListener);
        this.setKeyMapper();
        this.editorPane.addFocusListener(this.editorFocusListener);
        this.editorPane.addKeyListener(this);
        this.editorColorCodeAction = new EditorColorCodeAction(this.editorPane, this.undoableEditListener);
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public CodeCompleteRePopUpCtrl getCodeCompleteRePopUpCtrl() {
        return this.editorFocusListener.getCodeCompleteRePopUpCtrl();
    }

    public void setCommandExecutor(ICommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public void executeCommand() {
        if (this.commandExecutor != null) {
            this.commandExecutor.executeCommand();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        boolean isCtrlSpace;
        if (e.isAltDown()) {
            return;
        }
        if (e.isControlDown() && !(isCtrlSpace = KeyStrokeActionCtrl.matches(e, 32, false, true, false))) {
            return;
        }
        if (e.isMetaDown()) {
            return;
        }
        int keyCode = e.getKeyCode();
        if (keyCode != 27 && keyCode != 38 && keyCode != 40 && keyCode != 37 && keyCode != 39 && keyCode != 127 && keyCode != 17 && keyCode != 8 && keyCode != 18 && keyCode != 157 && keyCode != 16) {
            this.timedCodeCompleteDisplayer.checkShowCodeComplete(this.editorPane, this.getCodeCompleteRePopUpCtrl());
        }
    }

    private void setKeyMapper() {
        DbwEditorKeyStrokeMapper dbwEditorKeyStrokeMapper = new DbwEditorKeyStrokeMapper(this);
        this.keyListener = new DbwEditorKeyListener(this.editorPane, this.undoableEditListener, this.observable_);
        this.keyListener.addKeyStrokeActionMapper(this.undoableEditListener.getUndoCtrl());
        this.keyListener.addKeyStrokeActionMapper(dbwEditorKeyStrokeMapper);
    }

    private void doColorCode() {
        this.editorColorCodeAction.actionPerformed(null);
    }

    private void disableDefaultKeys() {
        DbwEditor.nullify(this.editorPane.getInputMap(0), KeyStroke.getKeyStroke(9, 0));
    }

    public void setText(String text) {
        boolean enabledColorCoding;
        this.editorPane.setText(text);
        int textLength = text.length();
        boolean bl = enabledColorCoding = textLength <= 30000;
        if (enabledColorCoding) {
            this.doColorCode();
        }
        this.keyListener.setColorCodingEnabled(enabledColorCoding);
        this.editorPane.setCaretPosition(0);
    }

    public String getText() {
        return this.editorPane.getText();
    }

    public String getSelectedText() {
        return this.editorPane.getSelectedText();
    }

    public void setEditable(boolean editable) {
        this.editorPane.setEditable(editable);
        Color grayColor = OsUtil.isMacOs() ? Colors.getGrayAlmostWhite() : Colors.getGrayUltraLight();
        Color backColor = editable ? Color.WHITE : grayColor;
        this.editorPane.setBackground(backColor);
        this.editorPane.setOpaque(true);
    }

    private static void nullify(InputMap im, KeyStroke ks) {
        Object key = im.get(ks);
        if (key != null) {
            im.put(ks, "none");
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    private class EditorFocusListener
    implements FocusListener {
        private final CodeCompleteRePopUpCtrl rePopUpCtrl = new CodeCompleteRePopUpCtrl();

        private EditorFocusListener() {
        }

        public CodeCompleteRePopUpCtrl getCodeCompleteRePopUpCtrl() {
            return this.rePopUpCtrl;
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

