/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.security;

import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.security.ILogin;
import com.harrand.coreclasses.security.IUser;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.coregui.panel.LoginChangePanel;
import com.harrand.dbwrenchgui.security.AuthenticationMgr;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class SecurityPanel
extends JPanel
implements IErgonomicPanel {
    private IUser user_;
    private JCheckBox chkPasswordPrompt_;
    private JButton btnChangePassword_;
    private SwingThemeCtrl themeCtrl_;

    public SecurityPanel(IUser user) {
        this.user_ = user;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
    }

    private void buildPanel() {
        this.initControls();
        this.layoutControls();
        this.loadData();
        this.setCosmetics();
        this.addListeners();
        this.setNames();
    }

    private void initControls() {
        this.chkPasswordPrompt_ = new JCheckBox(FileHelper.getResource("label.enable.password.prompt"));
        this.btnChangePassword_ = new JButton(FileHelper.getResource("label.change.password"));
    }

    private void layoutControls() {
        this.layoutControlsBox();
    }

    private void layoutControlsBox() {
        this.setLayout(new BorderLayout());
        HeaderPanel header = new HeaderPanel(this.getTitle(), 5, true);
        this.add((Component)header, "North");
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BoxLayout(controlsPanel, 3));
        controlsPanel.add(Box.createVerticalStrut(4));
        controlsPanel.add(this.btnChangePassword_);
        controlsPanel.add(Box.createVerticalStrut(4));
        controlsPanel.add(new JLabel("(To disable password protection set a blank password.)"));
        GuiHelper.addEmptyBorder(controlsPanel);
        this.add((Component)controlsPanel, "Center");
    }

    private void loadData() {
        this.chkPasswordPrompt_.setSelected(this.user_.getPromptForPassword());
    }

    private void setCosmetics() {
        this.btnChangePassword_.setMnemonic('P');
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.chkPasswordPrompt_);
        this.themeCtrl_.process(this.btnChangePassword_);
    }

    private void addListeners() {
        this.btnChangePassword_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityPanel.this.showPasswordChangeDisp();
            }
        });
    }

    private void setNames() {
        this.chkPasswordPrompt_.setName("chkPasswordPrompt");
        this.btnChangePassword_.setName("btnChangePassword");
    }

    private void showPasswordChangeDisp() {
        AuthenticationMgr mgr = AuthenticationMgr.getInstance();
        if (mgr.isAuthenticatedPrompt()) {
            this.showPasswordChange();
        } else {
            GuiMessageHelper.showInputErrMsg(null, FileHelper.getResource("err.login.required.title"), FileHelper.getResource("err.login.required.msg"));
        }
    }

    private void showPasswordChange() {
        ILogin newLogin = null;
        LoginChangePanel changePanel = new LoginChangePanel(this.user_);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, changePanel, changePanel.getPreferredBounds(), changePanel.getTitle());
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            newLogin = (ILogin)changePanel.getDataObject();
            try {
                if (newLogin != null) {
                    this.user_.setPassword(newLogin);
                }
            }
            catch (Exception e) {
                GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SECURITY;
    }

    @Override
    public String getTitle() {
        return "Security - Password Protect Server Connections";
    }

    @Override
    public String getToolTip() {
        return FileHelper.getRes("tooltip.security");
    }

    @Override
    public JButton getDefaultButton() {
        return this.btnChangePassword_;
    }
}

