/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.security;

import com.harrand.coreclasses.security.ILogin;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.LoginPanel;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;

public class AuthenticationMgr {
    private static final String AUTH_MSG = "A password has been set within DbWrench to access database servers.";
    private static final String AUTH_REQ = "Password Required";
    private static AuthenticationMgr instance__ = new AuthenticationMgr();
    private DbUser user_ = App.getUser();

    private AuthenticationMgr() {
    }

    public static AuthenticationMgr getInstance() {
        return instance__;
    }

    private void loginUser(ILogin login) {
        if (login != null) {
            try {
                this.user_.login(login);
            }
            catch (Exception e) {
                this.showLoginError(e);
            }
        }
    }

    public boolean isAuthenticatedPrompt() {
        ILogin login;
        boolean isAuthenticated = this.user_.isAuthenticated();
        if (!isAuthenticated && (login = this.promptForLogin()) != null) {
            isAuthenticated = true;
            this.loginUser(login);
        }
        return isAuthenticated;
    }

    private ILogin promptForLogin() {
        ILogin login = null;
        LoginPanel loginPanel = new LoginPanel(this.user_);
        EditDialog dlg = new EditDialog(null, true, loginPanel, loginPanel.getPreferredBounds(), loginPanel.getTitle(), AUTH_REQ, AUTH_MSG);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            login = (ILogin)loginPanel.getDataObject();
        } else {
            try {
                this.user_.logout();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return login;
    }

    private void logoutUser() {
        try {
            App.getUser().logout();
        }
        catch (Exception e) {
            this.showLoginError(e);
        }
    }

    private void showLoginError(Exception e) {
        GuiMessageHelper.showInputErrMsg(null, "Login Error", e.getMessage());
    }
}

