/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.run;

import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class ButtonConfig {
    private static Map toolTipMap_ = new HashMap();
    private static Map iconMap_ = new HashMap();
    private static Map textMap_ = new HashMap();
    private static Map mnemonicMap_ = new HashMap();
    private static Map acceleratorMap_ = new HashMap();
    private static SwingThemeCtrl themeCtrl__ = App.getThemeCtrl();

    public ButtonConfig() {
        ButtonConfig.loadMaps();
    }

    private static void loadMaps() {
        ButtonConfig.loadIconMap();
        ButtonConfig.loadToolTipMap();
        ButtonConfig.loadTextMap();
        ButtonConfig.loadMnemonicMap();
        ButtonConfig.loadAcceleratorMap();
    }

    private static void loadToolTipMap() {
        toolTipMap_.put(ButtonConfig.getNameAlignCenter(), ButtonConfig.getCommonRes("tooltip.align.center"));
        toolTipMap_.put(ButtonConfig.getNameAlignLeft(), ButtonConfig.getCommonRes("tooltip.align.left"));
        toolTipMap_.put(ButtonConfig.getNameAlignRight(), ButtonConfig.getCommonRes("tooltip.align.right"));
        toolTipMap_.put(ButtonConfig.getNameBold(), ButtonConfig.getCommonRes("tooltip.bold"));
        toolTipMap_.put(ButtonConfig.getNameCancel(), ButtonConfig.getCommonRes("tooltip.cancel"));
        toolTipMap_.put(ButtonConfig.getNameCascade(), ButtonConfig.getCommonRes("cascade.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameConnConfig(), ButtonConfig.getAppRes("connection.config.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameCopy(), ButtonConfig.getCommonRes("tooltip.copy"));
        toolTipMap_.put(ButtonConfig.getNameCreateDocs(), "Create Database Documentation");
        toolTipMap_.put(ButtonConfig.getNameCut(), ButtonConfig.getCommonRes("tooltip.cut"));
        toolTipMap_.put(ButtonConfig.getNameDelete(), ButtonConfig.getCommonRes("tooltip.delete"));
        toolTipMap_.put(ButtonConfig.getNameEdit(), ButtonConfig.getCommonRes("tooltip.edit"));
        toolTipMap_.put(ButtonConfig.getNameFind(), ButtonConfig.getCommonRes("tooltip.find"));
        toolTipMap_.put(ButtonConfig.getNameItalic(), ButtonConfig.getCommonRes("tooltip.italic"));
        toolTipMap_.put(ButtonConfig.getNameLicense(), ButtonConfig.getCommonRes("license.info.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameLogin(), ButtonConfig.getCommonRes("tooltip.login"));
        toolTipMap_.put(ButtonConfig.getNameLogout(), ButtonConfig.getCommonRes("logout.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameHelpContents(), ButtonConfig.getCommonRes("help.contents.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameMinimizeAll(), ButtonConfig.getCommonRes("minimize.all.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameNew(), ButtonConfig.getCommonRes("tooltip.new"));
        toolTipMap_.put(ButtonConfig.getNameOpen(), ButtonConfig.getCommonRes("tooltip.open"));
        toolTipMap_.put(ButtonConfig.getNameOptions(), ButtonConfig.getCommonRes("options.tooltip"));
        toolTipMap_.put(ButtonConfig.getNamePaste(), ButtonConfig.getCommonRes("tooltip.paste"));
        toolTipMap_.put(ButtonConfig.getNamePaste(), ButtonConfig.getCommonRes("tooltip.preferences"));
        toolTipMap_.put(ButtonConfig.getNameRedo(), ButtonConfig.getCommonRes("tooltip.redo"));
        toolTipMap_.put(ButtonConfig.getNameRenameHistory(), "Rename History");
        toolTipMap_.put(ButtonConfig.getNameReplace(), ButtonConfig.getCommonRes("tooltip.replace"));
        toolTipMap_.put(ButtonConfig.getNameRestoreAll(), ButtonConfig.getCommonRes("restore.all.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameDatabaseExplorer(), ButtonConfig.getAppRes("database.explorer.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameNavigator(), "Diagram Navigator");
        toolTipMap_.put(ButtonConfig.getNameForwardEngineer(), ButtonConfig.getAppRes("engineer.forward.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameReverseEngineer(), ButtonConfig.getAppRes("engineer.reverse.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameRuntimeInfo(), "Runtime Information");
        toolTipMap_.put(ButtonConfig.getNameRevSync(), "Database Compare");
        toolTipMap_.put(ButtonConfig.getNameSave(), ButtonConfig.getCommonRes("tooltip.save"));
        toolTipMap_.put(ButtonConfig.getNameSaveAs(), ButtonConfig.getCommonRes("tooltip.save.as"));
        toolTipMap_.put(ButtonConfig.getNameSchemaTransfer(), "Table Schema Transfer History");
        toolTipMap_.put(ButtonConfig.getNameSqlComm(), ButtonConfig.getAppRes("sql.comm.tooltip"));
        toolTipMap_.put(ButtonConfig.getNameUnderline(), ButtonConfig.getCommonRes("tooltip.underline"));
        toolTipMap_.put(ButtonConfig.getNameUndo(), ButtonConfig.getCommonRes("tooltip.undo"));
        toolTipMap_.put(ButtonConfig.getNameDiagram(), ButtonConfig.getCommonRes("tooltip.diagram"));
        toolTipMap_.put(ButtonConfig.getNameCreateDiagram(), ButtonConfig.getAppRes("diagram.create"));
    }

    private static void loadIconMap() {
        iconMap_.put(ButtonConfig.getNameAbout(), Icons.QUESTION_DLG);
        iconMap_.put(ButtonConfig.getNameAlignCenter(), Icons.ALIGN_CENTER);
        iconMap_.put(ButtonConfig.getNameAlignLeft(), Icons.ALIGN_LEFT);
        iconMap_.put(ButtonConfig.getNameAlignRight(), Icons.ALIGN_RIGHT);
        iconMap_.put(ButtonConfig.getNameAutoTest(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameBold(), Icons.BOLD);
        iconMap_.put(ButtonConfig.getNameCancel(), Icons.CANCEL);
        iconMap_.put(ButtonConfig.getNameCascade(), Icons.CASCADE);
        iconMap_.put(ButtonConfig.getNameConnConfig(), Icons.CONN_CFG);
        iconMap_.put(ButtonConfig.getNameCopy(), Icons.COPY);
        iconMap_.put(ButtonConfig.getNameCreateDocs(), Icons.DB_DOC);
        iconMap_.put(ButtonConfig.getNameCut(), Icons.CUT);
        iconMap_.put(ButtonConfig.getNameDatabaseExplorer(), Icons.DB_EXPL);
        iconMap_.put(ButtonConfig.getNameDelete(), Icons.DELETE);
        iconMap_.put(ButtonConfig.getNameExit(), Icons.EXIT);
        iconMap_.put(ButtonConfig.getNameForwardEngineer(), Icons.TO_SERVER);
        iconMap_.put(ButtonConfig.getNameFind(), Icons.FIND);
        iconMap_.put(ButtonConfig.getNameGoto(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameHelpContents(), Icons.QUESTION);
        iconMap_.put(ButtonConfig.getNameItalic(), Icons.ITALIC);
        iconMap_.put(ButtonConfig.getNameLicense(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameLaf(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameLogin(), Icons.SECURITY);
        iconMap_.put(ButtonConfig.getNameLogout(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameNavigator(), Icons.NAVIGATOR);
        iconMap_.put(ButtonConfig.getNameNew(), Icons.NEW);
        iconMap_.put(ButtonConfig.getNameOpen(), Icons.OPEN);
        iconMap_.put(ButtonConfig.getNameOptions(), Icons.PREFERENCES);
        iconMap_.put(ButtonConfig.getNamePaste(), Icons.PASTE);
        iconMap_.put(ButtonConfig.getNamePreferences(), Icons.PREFERENCES);
        iconMap_.put(ButtonConfig.getNameRedo(), Icons.REDO);
        iconMap_.put(ButtonConfig.getNameRenameHistory(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameReplace(), Icons.REPLACE);
        iconMap_.put(ButtonConfig.getNameReverseEngineer(), Icons.FROM_SERVER);
        iconMap_.put(ButtonConfig.getNameRuntimeInfo(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameRevSync(), Icons.REV_SYNC);
        iconMap_.put(ButtonConfig.getNameSave(), Icons.SAVE);
        iconMap_.put(ButtonConfig.getNameSaveAs(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameSchemaTransfer(), Icons.NULL_ICON);
        iconMap_.put(ButtonConfig.getNameSqlComm(), Icons.SQL_COMM);
        iconMap_.put(ButtonConfig.getNameTableDataViewer(), Icons.TABLE_DATA_VIEWER);
        iconMap_.put(ButtonConfig.getNameUnderline(), Icons.UNDERLINE);
        iconMap_.put(ButtonConfig.getNameUndo(), Icons.UNDO);
    }

    private static void loadTextMap() {
        textMap_.put(ButtonConfig.getNameAbout(), ButtonConfig.getCommonRes("about.label"));
        textMap_.put(ButtonConfig.getNameAlignCenter(), "Align Center");
        textMap_.put(ButtonConfig.getNameAlignLeft(), "Align Left");
        textMap_.put(ButtonConfig.getNameAlignRight(), "Align Right");
        textMap_.put(ButtonConfig.getNameAutoTest(), "Auto Test");
        textMap_.put(ButtonConfig.getNameBold(), "Bold");
        textMap_.put(ButtonConfig.getNameCancel(), ButtonConfig.getCommonRes("cancel"));
        textMap_.put(ButtonConfig.getNameCascade(), ButtonConfig.getCommonRes("cascade.label"));
        textMap_.put(ButtonConfig.getNameConnConfig(), ButtonConfig.getAppRes("display.plural.JdbcConfig"));
        textMap_.put(ButtonConfig.getNameCreateDocs(), "Create Documentation");
        textMap_.put(ButtonConfig.getNameDatabaseExplorer(), ButtonConfig.getAppRes("database.explorer.title"));
        textMap_.put(ButtonConfig.getNameNavigator(), "Navigator");
        textMap_.put(ButtonConfig.getNameFile(), ButtonConfig.getCommonRes("file"));
        textMap_.put(ButtonConfig.getNameNew(), ButtonConfig.getCommonRes("file.new"));
        textMap_.put(ButtonConfig.getNameOpen(), ButtonConfig.getCommonRes("file.open"));
        textMap_.put(ButtonConfig.getNameSave(), ButtonConfig.getCommonRes("file.save"));
        textMap_.put(ButtonConfig.getNameSaveAs(), ButtonConfig.getCommonRes("file.save.as"));
        textMap_.put(ButtonConfig.getNameLicense(), ButtonConfig.getCommonRes("license.info.title"));
        textMap_.put(ButtonConfig.getNameLaf(), "Set Look and Feel");
        textMap_.put(ButtonConfig.getNameLogin(), ButtonConfig.getCommonRes("file.login"));
        textMap_.put(ButtonConfig.getNameLogout(), ButtonConfig.getCommonRes("logout.label"));
        textMap_.put(ButtonConfig.getNameExit(), ButtonConfig.getCommonRes("file.exit"));
        textMap_.put(ButtonConfig.getNameEdit(), ButtonConfig.getCommonRes("edit"));
        textMap_.put(ButtonConfig.getNameForwardEngineer(), ButtonConfig.getAppRes("engineer.forward.title"));
        textMap_.put(ButtonConfig.getNameCopy(), ButtonConfig.getCommonRes("edit.copy"));
        textMap_.put(ButtonConfig.getNameCut(), ButtonConfig.getCommonRes("edit.cut"));
        textMap_.put(ButtonConfig.getNameDelete(), ButtonConfig.getCommonRes("edit.delete"));
        textMap_.put(ButtonConfig.getNameFind(), ButtonConfig.getCommonRes("edit.find"));
        textMap_.put(ButtonConfig.getNameGoto(), ButtonConfig.getCommonRes("edit.goto"));
        textMap_.put(ButtonConfig.getNameHelp(), ButtonConfig.getCommonRes("help.label"));
        textMap_.put(ButtonConfig.getNameHelpContents(), ButtonConfig.getCommonRes("help.contents.label"));
        textMap_.put(ButtonConfig.getNameMinimizeAll(), ButtonConfig.getCommonRes("minimize.all.label"));
        textMap_.put(ButtonConfig.getNameOptions(), ButtonConfig.getCommonRes("options.label"));
        textMap_.put(ButtonConfig.getNamePaste(), ButtonConfig.getCommonRes("edit.paste"));
        textMap_.put(ButtonConfig.getNamePreferences(), ButtonConfig.getCommonRes("edit.preferences"));
        textMap_.put(ButtonConfig.getNameRedo(), ButtonConfig.getCommonRes("edit.redo"));
        textMap_.put(ButtonConfig.getNameRenameHistory(), "Rename History");
        textMap_.put(ButtonConfig.getNameRestoreAll(), ButtonConfig.getCommonRes("restore.all.label"));
        textMap_.put(ButtonConfig.getNameReverseEngineer(), ButtonConfig.getAppRes("engineer.reverse.title"));
        textMap_.put(ButtonConfig.getNameRuntimeInfo(), "Runtime Information");
        textMap_.put(ButtonConfig.getNameRevSync(), "Database Compare");
        textMap_.put(ButtonConfig.getNameReplace(), ButtonConfig.getCommonRes("edit.replace"));
        textMap_.put(ButtonConfig.getNameSchemaTransfer(), "Table Transfer History");
        textMap_.put(ButtonConfig.getNameSqlComm(), ButtonConfig.getAppRes("sql.comm.label"));
        textMap_.put(ButtonConfig.getNameTableDataViewer(), ButtonConfig.getCommonRes("table.data.viewer"));
        textMap_.put(ButtonConfig.getNameTools(), ButtonConfig.getCommonRes("tools"));
        textMap_.put(ButtonConfig.getNameUndo(), ButtonConfig.getCommonRes("edit.undo"));
        textMap_.put(ButtonConfig.getNameWindow(), ButtonConfig.getCommonRes("window.label"));
        textMap_.put(ButtonConfig.getNameItalic(), "Italic");
        textMap_.put(ButtonConfig.getNameUnderline(), "Underline");
        textMap_.put(ButtonConfig.getNameDiagram(), ButtonConfig.getAppRes("diagram"));
        textMap_.put(ButtonConfig.getNameCreateDiagram(), ButtonConfig.getAppRes("diagram.create"));
    }

    private static void loadMnemonicMap() {
        mnemonicMap_.put(ButtonConfig.getNameAbout(), "A");
        mnemonicMap_.put(ButtonConfig.getNameAlignCenter(), "C");
        mnemonicMap_.put(ButtonConfig.getNameAlignLeft(), "L");
        mnemonicMap_.put(ButtonConfig.getNameAlignRight(), "R");
        mnemonicMap_.put(ButtonConfig.getNameAutoTest(), "T");
        mnemonicMap_.put(ButtonConfig.getNameBold(), "B");
        mnemonicMap_.put(ButtonConfig.getNameCancel(), "C");
        mnemonicMap_.put(ButtonConfig.getNameCascade(), "C");
        mnemonicMap_.put(ButtonConfig.getNameConnConfig(), "C");
        mnemonicMap_.put(ButtonConfig.getNameCopy(), "C");
        mnemonicMap_.put(ButtonConfig.getNameCreateDocs(), "D");
        mnemonicMap_.put(ButtonConfig.getNameCut(), "T");
        mnemonicMap_.put(ButtonConfig.getNameDatabaseExplorer(), "E");
        mnemonicMap_.put(ButtonConfig.getNameExit(), "X");
        mnemonicMap_.put(ButtonConfig.getNameNavigator(), "N");
        mnemonicMap_.put(ButtonConfig.getNameDelete(), "D");
        mnemonicMap_.put(ButtonConfig.getNameEdit(), "E");
        mnemonicMap_.put(ButtonConfig.getNameFile(), "F");
        mnemonicMap_.put(ButtonConfig.getNameFind(), "F");
        mnemonicMap_.put(ButtonConfig.getNameForwardEngineer(), "F");
        mnemonicMap_.put(ButtonConfig.getNameItalic(), "I");
        mnemonicMap_.put(ButtonConfig.getNameHelp(), "H");
        mnemonicMap_.put(ButtonConfig.getNameHelpContents(), "C");
        mnemonicMap_.put(ButtonConfig.getNameLicense(), "L");
        mnemonicMap_.put(ButtonConfig.getNameLogin(), "L");
        mnemonicMap_.put(ButtonConfig.getNameMinimizeAll(), "M");
        mnemonicMap_.put(ButtonConfig.getNameNew(), "N");
        mnemonicMap_.put(ButtonConfig.getNameOpen(), "O");
        mnemonicMap_.put(ButtonConfig.getNameOptions(), "O");
        mnemonicMap_.put(ButtonConfig.getNamePaste(), "P");
        mnemonicMap_.put(ButtonConfig.getNamePreferences(), "E");
        mnemonicMap_.put(ButtonConfig.getNameRedo(), "O");
        mnemonicMap_.put(ButtonConfig.getNameRenameHistory(), "R");
        mnemonicMap_.put(ButtonConfig.getNameReplace(), "P");
        mnemonicMap_.put(ButtonConfig.getNameReverseEngineer(), "R");
        mnemonicMap_.put(ButtonConfig.getNameRevSync(), "Y");
        mnemonicMap_.put(ButtonConfig.getNameRestoreAll(), "R");
        mnemonicMap_.put(ButtonConfig.getNameRuntimeInfo(), "R");
        mnemonicMap_.put(ButtonConfig.getNameSave(), "S");
        mnemonicMap_.put(ButtonConfig.getNameSaveAs(), "A");
        mnemonicMap_.put(ButtonConfig.getNameSqlComm(), "Q");
        mnemonicMap_.put(ButtonConfig.getNameTableDataViewer(), "V");
        mnemonicMap_.put(ButtonConfig.getNameTools(), "T");
        mnemonicMap_.put(ButtonConfig.getNameUnderline(), "L");
        mnemonicMap_.put(ButtonConfig.getNameUndo(), "U");
        mnemonicMap_.put(ButtonConfig.getNameWindow(), "W");
        mnemonicMap_.put(ButtonConfig.getNameDiagram(), "V");
        mnemonicMap_.put(ButtonConfig.getNameDiagram(), "D");
        mnemonicMap_.put(ButtonConfig.getNameCreateDiagram(), "C");
    }

    private static void loadAcceleratorMap() {
        acceleratorMap_.put(ButtonConfig.getNameUndo(), KeyStroke.getKeyStroke(90, 2));
        acceleratorMap_.put(ButtonConfig.getNameRedo(), KeyStroke.getKeyStroke(89, 2));
        acceleratorMap_.put(ButtonConfig.getNameNew(), KeyStroke.getKeyStroke(78, 2));
        acceleratorMap_.put(ButtonConfig.getNameNavigator(), KeyStroke.getKeyStroke(78, 8));
        acceleratorMap_.put(ButtonConfig.getNameSave(), KeyStroke.getKeyStroke(83, 2));
        acceleratorMap_.put(ButtonConfig.getNameCopy(), KeyStroke.getKeyStroke(67, 2));
        acceleratorMap_.put(ButtonConfig.getNameCut(), KeyStroke.getKeyStroke(88, 2));
        acceleratorMap_.put(ButtonConfig.getNamePaste(), KeyStroke.getKeyStroke(86, 2));
        acceleratorMap_.put(ButtonConfig.getNameReplace(), KeyStroke.getKeyStroke(72, 2));
        acceleratorMap_.put(ButtonConfig.getNameFind(), KeyStroke.getKeyStroke(70, 2));
        acceleratorMap_.put(ButtonConfig.getNameOpen(), KeyStroke.getKeyStroke(79, 2));
        acceleratorMap_.put(ButtonConfig.getNameGoto(), KeyStroke.getKeyStroke(71, 2));
        acceleratorMap_.put(ButtonConfig.getNameDiagram(), KeyStroke.getKeyStroke(68, 2));
        acceleratorMap_.put(ButtonConfig.getNameWindow(), KeyStroke.getKeyStroke(87, 2));
        acceleratorMap_.put(ButtonConfig.getNameSqlComm(), KeyStroke.getKeyStroke(81, 2));
        acceleratorMap_.put(ButtonConfig.getNameRevSync(), KeyStroke.getKeyStroke(89, 8));
        acceleratorMap_.put(ButtonConfig.getNameHelpContents(), KeyStroke.getKeyStroke(112, 0));
        acceleratorMap_.put(ButtonConfig.getNameAutoTest(), KeyStroke.getKeyStroke(84, 9));
        acceleratorMap_.put(ButtonConfig.getNameForwardEngineer(), KeyStroke.getKeyStroke(118, 0));
        acceleratorMap_.put(ButtonConfig.getNameReverseEngineer(), KeyStroke.getKeyStroke(118, 8));
        acceleratorMap_.put(ButtonConfig.getNameDatabaseExplorer(), KeyStroke.getKeyStroke(114, 0));
        acceleratorMap_.put(ButtonConfig.getNameTableDataViewer(), KeyStroke.getKeyStroke(120, 0));
        acceleratorMap_.put(ButtonConfig.getNameCreateDocs(), KeyStroke.getKeyStroke(120, 8));
    }

    public static void setMenuProps(JMenu menu) {
        String name = ButtonConfig.getParsedName(menu.getName());
        menu.setText(ButtonConfig.getText(name));
        menu.setMnemonic(ButtonConfig.getMnemonic(name));
        SwingUtilities.updateComponentTreeUI(menu);
    }

    public static void setMenuItemProps(JMenuItem item) {
        if (item.getName() != null) {
            String name = ButtonConfig.getParsedName(item.getName());
            item.setIcon(ButtonConfig.getIcon(name));
            item.setText(ButtonConfig.getText(name));
            item.setAccelerator(ButtonConfig.getAccelerator(name));
            item.setMnemonic(ButtonConfig.getMnemonic(name));
            SwingUtilities.updateComponentTreeUI(item);
        }
    }

    public static void setToolBarButtonProps(JButton item) {
        String name = ButtonConfig.getParsedName(item.getName());
        item.setIcon(ButtonConfig.getIcon(name));
        item.setText("");
        item.setToolTipText(ButtonConfig.getToolTip(name));
        themeCtrl__.processToolbarButton(item);
    }

    private static String getParsedName(String rawName) {
        return rawName.substring(3);
    }

    public static Icon getIcon(String name) {
        if (iconMap_.size() == 0) {
            ButtonConfig.loadIconMap();
        }
        return (Icon)iconMap_.get(name);
    }

    private static String getCommonRes(String key) {
        return FileHelper.getResource(key);
    }

    private static String getAppRes(String key) {
        return App.getResource(key);
    }

    public static String getText(String name) {
        if (textMap_.size() == 0) {
            ButtonConfig.loadTextMap();
        }
        return (String)textMap_.get(name);
    }

    public static String getToolTip(String name) {
        if (toolTipMap_.isEmpty()) {
            ButtonConfig.loadToolTipMap();
        }
        return (String)toolTipMap_.get(name);
    }

    public static KeyStroke getAccelerator(String name) {
        if (acceleratorMap_.isEmpty()) {
            ButtonConfig.loadAcceleratorMap();
        }
        return (KeyStroke)acceleratorMap_.get(name);
    }

    public static char getMnemonic(String name) {
        String str;
        if (mnemonicMap_.isEmpty()) {
            ButtonConfig.loadMnemonicMap();
        }
        if ((str = (String)mnemonicMap_.get(name)) != null) {
            return str.toCharArray()[0];
        }
        return '0';
    }

    public static String getNameAbout() {
        return "About";
    }

    public static String getNameAlignCenter() {
        return "AlignCenter";
    }

    public static String getNameAlignLeft() {
        return "AlignLeft";
    }

    public static String getNameAlignRight() {
        return "AlignRight";
    }

    public static String getNameAutoTest() {
        return "AutoTest";
    }

    public static String getNameBold() {
        return "Bold";
    }

    public static String getNameCascade() {
        return "Cascade";
    }

    public static String getNameCancel() {
        return "Cancel";
    }

    public static String getNameConnConfig() {
        return "ConnConfig";
    }

    public static String getNameCopy() {
        return "Copy";
    }

    public static String getNameCreateDocs() {
        return "CreateDocs";
    }

    public static String getNameCut() {
        return "Cut";
    }

    public static String getNameDatabaseExplorer() {
        return "DatabaseExplorer";
    }

    public static String getNameNavigator() {
        return "Navigator";
    }

    public static String getNameDelete() {
        return "Delete";
    }

    public static String getNameEdit() {
        return "Edit";
    }

    public static String getNameExit() {
        return "Exit";
    }

    public static String getNameFind() {
        return "Find";
    }

    public static String getNameForwardEngineer() {
        return "ForwardEngineer";
    }

    public static String getNameFile() {
        return "File";
    }

    public static String getNameGoto() {
        return "Goto";
    }

    public static String getNameHelp() {
        return "Help";
    }

    public static String getNameHelpContents() {
        return "HelpContents";
    }

    public static String getNameItalic() {
        return "Italic";
    }

    public static String getNameLicense() {
        return "License";
    }

    public static String getNameLaf() {
        return "Laf";
    }

    public static String getNameLogin() {
        return "Login";
    }

    public static String getNameLogout() {
        return "Logout";
    }

    public static String getNameMinimizeAll() {
        return "MinimizeAll";
    }

    public static String getNameNew() {
        return "New";
    }

    public static String getNameOptions() {
        return "Options";
    }

    public static String getNameOpen() {
        return "Open";
    }

    public static String getNamePaste() {
        return "Paste";
    }

    public static String getNamePreferences() {
        return "Preferences";
    }

    public static String getNameRedo() {
        return "Redo";
    }

    public static String getNameRenameHistory() {
        return "Rename History";
    }

    public static String getNameReplace() {
        return "Replace";
    }

    public static String getNameRestoreAll() {
        return "RestoreAll";
    }

    public static String getNameReverseEngineer() {
        return "ReverseEngineer";
    }

    public static String getNameRuntimeInfo() {
        return "RuntimeInformation";
    }

    public static String getNameRevSync() {
        return "RevSync";
    }

    public static String getNameSave() {
        return "Save";
    }

    public static String getNameSaveAs() {
        return "SaveAs";
    }

    public static String getNameSchemaTransfer() {
        return "SchTransfer";
    }

    public static String getNameSqlComm() {
        return "SqlComm";
    }

    public static String getNameTools() {
        return "Tools";
    }

    public static String getNameTableDataViewer() {
        return "TableDataViewer";
    }

    public static String getNameUndo() {
        return "Undo";
    }

    public static String getNameUnderline() {
        return "Underline";
    }

    public static String getNameWindow() {
        return "Window";
    }

    public static String getNameDiagram() {
        return "Diagram";
    }

    public static String getNameCreateDiagram() {
        return "CreateDiagram";
    }
}

