/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print.ctrl;

import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrenchgui.print.DiagramPage;
import com.harrand.dbwrenchgui.print.PageGroup;
import com.harrand.dbwrenchgui.print.PreviewTile;
import com.harrand.dbwrenchgui.print.ctrl.PrintDiagramCtrl;
import com.harrand.dbwrenchgui.print.page.PageMargins;
import com.harrand.util.LogUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.List;

public class PrintPreviewCtrl
implements IObservable {
    private PrintDiagramCtrl printDiagramCtrl_;
    private List<PreviewTile> tiles_;
    private BasicObservable observable_ = new BasicObservable();
    public static final double REDUCTION_RATIO = 0.3;
    public static final int TILE_SPACING = 15;

    public List<PreviewTile> getPreviewTiles() {
        return this.tiles_;
    }

    public void setPrintDiagramCtrl(PrintDiagramCtrl printDiagramCtrl) {
        this.printDiagramCtrl_ = printDiagramCtrl;
    }

    public void refreshByPreview() {
        this.refreshPageGroup();
        this.refreshTiles();
    }

    public void refreshPreview() {
        this.refreshTiles();
        this.notifyObservers(new UpdateChain(this));
    }

    private void refreshTiles() {
        Dimension tileSz = this.calcTileSz();
        PageMargins margins = this.getPageGroup().getPageMargins();
        int panelCursorX = 100;
        int panelCursorY = 100;
        int tileTravelX = tileSz.width + 15;
        int tileTravelY = tileSz.height + 15;
        this.tiles_ = new ArrayList<PreviewTile>();
        for (DiagramPage page : this.getPageGroup().getPages()) {
            int row = page.getRow();
            int col = page.getCol();
            int tileX = 15 + col * tileTravelX;
            int tileY = 15 + row * tileTravelY;
            Point tileLocation = new Point(tileX, tileY);
            panelCursorX = Math.max(panelCursorX, tileX + tileSz.width + 15);
            panelCursorY = Math.max(panelCursorY, tileY + tileSz.height + 15);
            BufferedImage previewImg = page.getScaledImage(0.3 * page.getWidthUsedRatio(), 0.3 * page.getHeightUsedRatio());
            PreviewTile tile = new PreviewTile(previewImg, page.getPageNumber(), tileLocation, tileSz, margins);
            this.tiles_.add(tile);
        }
    }

    private Dimension calcTileSz() {
        PageFormat pageFormat = this.printDiagramCtrl_.getPageFormatCtrl().getPageFormat();
        double pageW = pageFormat.getWidth();
        double pageH = pageFormat.getHeight();
        int tileW = (int)(pageW * 0.3);
        int tileH = (int)(pageH * 0.3);
        return new Dimension(tileW, tileH);
    }

    private void refreshPageGroup() {
        if (this.isPrintDiagramCtrlSet()) {
            this.printDiagramCtrl_.refreshPageGroup();
        }
    }

    private PageGroup getPageGroup() {
        if (this.isPrintDiagramCtrlSet()) {
            return this.printDiagramCtrl_.getPageGroup();
        }
        return new PageGroup(new ArrayList<DiagramPage>(), new PageFormat());
    }

    private boolean isPrintDiagramCtrlSet() {
        boolean isSet;
        boolean bl = isSet = this.printDiagramCtrl_ != null;
        if (!isSet) {
            LogUtil.logErr("PrintPreviewCtrl.warning: PrintDiagramCtrl is not set!");
        }
        return isSet;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }
}

