/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print.ctrl;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.DbDrawableOrderer;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchgui.print.DiagramPartitioner;
import com.harrand.dbwrenchgui.print.PageGroup;
import com.harrand.dbwrenchgui.print.PrintFacade;
import com.harrand.dbwrenchgui.print.ctrl.PageFormatCtrl;
import com.harrand.dbwrenchgui.print.ctrl.PrintPreviewCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.draw.DiagramDrawer;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.List;

public class PrintDiagramCtrl
implements IObserver,
IObservable {
    private PrintPreviewCtrl previewCtrl_;
    private PageFormatCtrl formatCtrl_;
    private DiagramDrawer diagramDrawer = new DiagramDrawer(new DbDrawableOrderer());
    private BufferedImage diagramImg;
    private DiagramPartitioner partitioner_ = new DiagramPartitioner();
    private Diagram diagram;
    private PageGroup pageGroup_;
    private Database db_;
    private BasicObservable observable_ = new BasicObservable();

    public PrintDiagramCtrl() {
        this.createSubCtrls();
        CentralLookup.getDefault().addObserver(this);
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        this.updateDiagramImage();
        this.refreshPreview();
    }

    public void print() {
        PrintFacade.getInstance().printDisp(this.pageGroup_);
    }

    public PrintPreviewCtrl getPrintPreviewCtrl() {
        return this.previewCtrl_;
    }

    public PageFormatCtrl getPageFormatCtrl() {
        return this.formatCtrl_;
    }

    public BufferedImage getDiagramImage() {
        return this.diagramImg;
    }

    public PageGroup getPageGroup() {
        return this.pageGroup_;
    }

    public List<Diagram> getDiagrams() {
        List<Diagram> diagrams = new ArrayList<Diagram>();
        Database db = LookupUtil.getLookupDb();
        if (db != null) {
            diagrams = db.getDiagramsGen();
        }
        return diagrams;
    }

    public void refreshPreview() {
        this.refreshPageGroup();
        this.previewCtrl_.refreshPreview();
    }

    private void updateDiagramImage() {
        this.diagramImg = this.diagram != null ? this.diagramDrawer.getDiagramImage(this.diagram) : GuiHelper.getBufferedImage(100, 100, true);
    }

    private void createSubCtrls() {
        this.previewCtrl_ = new PrintPreviewCtrl();
        this.previewCtrl_.setPrintDiagramCtrl(this);
        this.formatCtrl_ = new PageFormatCtrl();
        this.formatCtrl_.addObserver(this);
    }

    public void refreshPageGroup() {
        PageFormat format = this.formatCtrl_.getPageFormat();
        this.updateDiagramImage();
        this.pageGroup_ = this.partitioner_.createPageGroup(this.diagramImg, format);
    }

    private void checkDbChanged(UpdateChain chain) {
        if (LookupUtil.hasDbChanged(this.db_)) {
            this.db_ = LookupUtil.getLookupDb();
            this.notifyObservers(chain);
        }
    }

    private void checkPageFormatChanged(UpdateChain chain) {
        if (this.diagram != null && chain.hasClassName(PageFormatCtrl.class.getName())) {
            this.refreshPreview();
        }
    }

    @Override
    public void update(UpdateChain chain) {
        this.checkPageFormatChanged(chain);
        this.checkDbChanged(chain);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }
}

