/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrenchgui.print.page.PageMargins;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class PreviewTile {
    private final BufferedImage previewImg_;
    private BufferedImage tileImg_;
    private final int pageNumber_;
    private final Point location;
    private final Dimension size;
    private final PageMargins pageMargins;
    private Graphics2D g2_;
    public static final int BORDER_WIDTH = 3;
    public static final double REDUCTION_RATIO = 0.3;

    public PreviewTile(BufferedImage previewImg, int pageNumber, Point tileLocation, Dimension tileSz, PageMargins pageMargins) {
        this.pageNumber_ = pageNumber;
        this.previewImg_ = previewImg;
        this.pageMargins = pageMargins;
        this.location = tileLocation;
        this.size = tileSz;
        this.drawImages();
    }

    public BufferedImage getImage() {
        return this.tileImg_;
    }

    public int getPageNumber() {
        return this.pageNumber_;
    }

    public Point getLocation() {
        return this.location;
    }

    public Dimension getSize() {
        return this.size;
    }

    private void drawImages() {
        this.createBufferedImage();
        this.drawBackColor();
        this.drawPreviewImg();
        this.drawBorder();
        this.drawPageText();
    }

    private void createBufferedImage() {
        this.tileImg_ = GuiHelper.getBufferedImage(this.size.width, this.size.height, true);
        this.g2_ = (Graphics2D)this.tileImg_.getGraphics();
        this.g2_.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private void drawBackColor() {
        GuiHelper.setBackColor(this.g2_, Colors.getGrayUltraLight(), this.size.width, this.size.height);
    }

    private void drawPreviewImg() {
        int previewImgX = this.pageMargins.getLeftMarginScaled(0.3);
        int previewImgY = this.pageMargins.getTopMarginScaled(0.3);
        int usableW = this.size.width - this.pageMargins.getRightMarginScaled(0.3) - previewImgX;
        int usableH = this.size.height - this.pageMargins.getBottomMarginScaled(0.3) - previewImgY;
        this.g2_.setPaint(Color.WHITE);
        this.g2_.fillRect(previewImgX, previewImgY, usableW, usableH);
        this.g2_.drawImage((Image)this.previewImg_, previewImgX, previewImgY, null);
    }

    private void drawPageText() {
        String pageStr = Integer.toString(this.pageNumber_);
        AlphaComposite alphaComposite = GuiHelper.getTransparentComposite(0.4f);
        this.g2_.setComposite(alphaComposite);
        this.g2_.setPaint(Color.GRAY);
        this.g2_.setFont(new Font("Arial", 1, 34));
        GuiHelper.drawCenteredText(pageStr, this.size.width, this.size.height, this.g2_);
    }

    private void drawBorder() {
        int borderMiddle = 1;
        int borderX = this.size.width - borderMiddle;
        int borderY = this.size.height - borderMiddle;
        this.g2_.setPaint(Color.GRAY);
        this.g2_.setStroke(new BasicStroke(3.0f));
        this.g2_.drawLine(0, 0, borderX, 0);
        this.g2_.drawLine(borderX, 0, borderX, borderY);
        this.g2_.drawLine(borderX, borderY, 0, borderY);
        this.g2_.drawLine(0, borderY, 0, 0);
        this.g2_.setStroke(new BasicStroke(1.0f));
    }
}

