/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class DiagramPage {
    private BufferedImage image_;
    private int pageNumber_;
    private int row_;
    private int col_;
    private double widthUsedRatio_;
    private double heightUsedRatio_;

    public DiagramPage(int pageNumber, BufferedImage image) {
        this.pageNumber_ = pageNumber;
        this.image_ = image;
    }

    public void setCol(int col) {
        this.col_ = col;
    }

    public void setRow(int row) {
        this.row_ = row;
    }

    public void setWidthUsedRatio(double widthUsedRatio) {
        this.widthUsedRatio_ = widthUsedRatio;
    }

    public void setHeightUsedRatio(double heightUsedRatio) {
        this.heightUsedRatio_ = heightUsedRatio;
    }

    public double getWidthUsedRatio() {
        return this.widthUsedRatio_;
    }

    public double getHeightUsedRatio() {
        return this.heightUsedRatio_;
    }

    public BufferedImage getImage() {
        return this.image_;
    }

    public int getPageNumber() {
        return this.pageNumber_;
    }

    public int getCol() {
        return this.col_;
    }

    public int getRow() {
        return this.row_;
    }

    public BufferedImage getScaledImage(double widthScale, double heightScale) {
        return this.getScaledImageDisp((int)(widthScale * (double)this.image_.getWidth()), (int)(heightScale * (double)this.image_.getHeight()));
    }

    private BufferedImage getScaledImageDisp(int scaledWidth, int scaledHeight) {
        int adjustedWidth = scaledWidth > 0 ? scaledWidth : 1;
        int adjustedHeight = scaledHeight > 0 ? scaledHeight : 1;
        BufferedImage scaledBI = new BufferedImage(adjustedWidth, adjustedHeight, 2);
        Graphics2D g = scaledBI.createGraphics();
        boolean preserveAlpha = false;
        if (preserveAlpha) {
            g.setComposite(AlphaComposite.Src);
        }
        g.drawImage(this.image_, 0, 0, adjustedWidth, adjustedHeight, null);
        g.dispose();
        return scaledBI;
    }
}

