/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.subpanel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.validators.DataTypeFieldsValidator;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.panel.subpanel.IDataTypeChangeListener;
import com.harrand.util.FileHelper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataTypePanel
extends JPanel
implements DataEditor {
    private final DataTypeSvr dataTypeSvr_;
    private final IOptionMgr dtOptMgr_;
    private JLabel lblDataType_;
    private JComboBox cboDataType_;
    private JLabel lblLength_;
    private final JTextField txtLength_ = new JTextField("");
    private JLabel lblScale_;
    private final JTextField txtScale_ = new JTextField("");
    private JCheckBox chkUnsigned_;
    private boolean syncOnEdit_ = false;
    private InputVerifier verifier_;
    private ActionListener editSyncActionListener_;
    private ActionListener autoLengthListener_;
    private ActionListener autoScaleListener_;
    private ActionListener lisDataType_;
    private final Column column;
    private IDataTypeChangeListener dataTypeChangeListener;

    public DataTypePanel(Column column) {
        this.column = column;
        this.dtOptMgr_ = App.getUser().getOptionMgr("data.type.opt.mgr");
        this.dataTypeSvr_ = new DataTypeSvr(this.dtOptMgr_);
        this.setupGui();
    }

    private void setupGui() {
        this.buildComponents();
        this.layoutComponents();
        this.loadData();
        this.setCosmetics();
        this.buildListeners();
        this.updateDisplay();
    }

    private void buildComponents() {
        this.cboDataType_ = new JComboBox(new Vector(this.dataTypeSvr_.getEnabledTypes()));
        this.lblLength_ = new JLabel(FileHelper.getResource("length.label"));
        this.lblScale_ = new JLabel(FileHelper.getResource("scale.label"));
        this.lblDataType_ = new JLabel(App.getResource("data.type.label"));
        this.chkUnsigned_ = new JCheckBox("Unsigned");
    }

    private void layoutComponents() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairFixed(this.lblDataType_, this.cboDataType_, gbc, this, row++);
        GuiHelper.addGridbagPair(this.lblLength_, GuiHelper.getRightGluedPanel(this.txtLength_), gbc, this, row++);
        GuiHelper.addGridbagPair(this.lblScale_, GuiHelper.getRightGluedPanel(this.txtScale_), gbc, this, row++);
        GuiHelper.addGridbagPair(new JLabel(), this.getUnsignedPanel(), gbc, this, row++);
        GuiHelper.addTitledEmptyBorder(this, "DataType");
    }

    private JPanel getUnsignedPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.add(this.chkUnsigned_);
        return panel;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtLength_.setInputVerifier(this.verifier_);
            this.txtScale_.setInputVerifier(this.verifier_);
            this.txtLength_.addActionListener(this.editSyncActionListener_);
            this.txtScale_.addActionListener(this.editSyncActionListener_);
            this.cboDataType_.addActionListener(this.editSyncActionListener_);
            this.chkUnsigned_.addActionListener(this.editSyncActionListener_);
        } else {
            this.txtLength_.setInputVerifier(null);
            this.txtScale_.setInputVerifier(null);
            this.txtLength_.removeActionListener(this.editSyncActionListener_);
            this.txtScale_.removeActionListener(this.editSyncActionListener_);
            this.cboDataType_.removeActionListener(this.editSyncActionListener_);
            this.chkUnsigned_.removeActionListener(this.editSyncActionListener_);
        }
    }

    public void refreshTxtLength() {
        IDataType dataType;
        boolean used = this.getLengthUsed();
        this.txtLength_.setEnabled(used);
        this.lblLength_.setEnabled(used);
        if (!used) {
            this.txtLength_.setText("");
        }
        String toolTip = (dataType = this.getDataType()) != null ? dataType.getLengthUnitsDesc() : "";
        this.txtLength_.setToolTipText(toolTip);
    }

    public void refreshTxtScale() {
        IDataType dataType;
        boolean used = this.getScaleUsed();
        this.txtScale_.setEnabled(used);
        this.lblScale_.setEnabled(used);
        if (!used) {
            this.txtScale_.setText("");
        }
        String toolTip = (dataType = this.getDataType()) != null ? dataType.getScaleUnitsDesc() : "";
        this.txtScale_.setToolTipText(toolTip);
    }

    public IDataType getDataType() {
        return (IDataType)this.cboDataType_.getSelectedItem();
    }

    public Integer getLength() {
        String strLength = this.txtLength_.getText();
        Integer length = StrHelper.isInteger(strLength) ? new Integer(strLength) : null;
        return length;
    }

    public Integer getScale() {
        String strScale = this.txtScale_.getText();
        Integer scale = StrHelper.isInteger(strScale) ? new Integer(strScale) : null;
        return scale;
    }

    public boolean getSigned() {
        boolean signed = !this.chkUnsigned_.isSelected();
        return signed;
    }

    public void setDataTypeChangeListener(IDataTypeChangeListener dataTypeChangeListener) {
        this.dataTypeChangeListener = dataTypeChangeListener;
    }

    public void refresh() {
        this.refreshTxtLength();
        this.refreshTxtScale();
        this.refreshChkUnsigned();
    }

    private void setCosmetics() {
        this.cboDataType_.setPrototypeDisplayValue("TimeStampWithTimeZone++");
        GuiHelper.setWidthRestrictions(this.txtLength_);
        GuiHelper.setWidthRestrictions(this.txtScale_);
        this.chkUnsigned_.setMnemonic(71);
    }

    @Override
    public ITestResult validateData() {
        IDataType dataType = (IDataType)this.cboDataType_.getSelectedItem();
        String strLength = this.txtLength_.getText();
        String strScale = this.txtScale_.getText();
        boolean signed = !this.chkUnsigned_.isSelected();
        DataTypeFieldsValidator validator = new DataTypeFieldsValidator();
        return validator.validateFields(dataType, strLength, strScale, signed);
    }

    private void refreshChkUnsigned() {
        boolean used = this.getUnsignedUsed();
        this.chkUnsigned_.setEnabled(used);
        if (!used) {
            this.chkUnsigned_.setSelected(false);
        }
    }

    private boolean getLengthUsed() {
        IDataType dataType = this.getDataType();
        boolean used = dataType != null ? dataType.isLengthUsed() : false;
        return used;
    }

    private boolean getScaleUsed() {
        IDataType dataType = this.getDataType();
        boolean used = dataType != null ? dataType.isScaleUsed() : false;
        return used;
    }

    private void buildListeners() {
        this.autoLengthListener_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypePanel.this.checkAutoLength();
            }
        };
        this.autoScaleListener_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypePanel.this.checkAutoScale();
            }
        };
        this.lisDataType_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypePanel.this.updateDisplay();
            }
        };
        this.cboDataType_.addActionListener(this.autoLengthListener_);
        this.cboDataType_.addActionListener(this.autoScaleListener_);
        this.cboDataType_.addActionListener(this.lisDataType_);
        ActionListener dataTypeChangeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DataTypePanel.this.dataTypeChangeListener != null) {
                    DataTypePanel.this.dataTypeChangeListener.notifyDataTypeChanged();
                }
            }
        };
        this.cboDataType_.addActionListener(dataTypeChangeActionListener);
    }

    private void updateDisplay() {
        this.refreshTxtLength();
        this.refreshTxtScale();
        this.refreshChkUnsigned();
    }

    private void checkAutoLength() {
        Integer defaultLength;
        if (this.txtLength_.getText().equals("") && (defaultLength = this.getDataType().getDefaultLength()) != null) {
            this.txtLength_.setText(defaultLength.toString());
        }
    }

    private void checkAutoScale() {
        Integer defaultScale;
        if (this.txtScale_.getText().equals("") && (defaultScale = this.getDataType().getDefaultScale()) != null) {
            this.txtScale_.setText(defaultScale.toString());
        }
    }

    public void loadData() {
        if (this.column != null) {
            this.cboDataType_.removeActionListener(this.editSyncActionListener_);
            this.cboDataType_.removeActionListener(this.autoLengthListener_);
            this.cboDataType_.setSelectedItem(DataTypeSvr.getDataType(this.column.getDataTypeId()));
            this.cboDataType_.addActionListener(this.editSyncActionListener_);
            this.cboDataType_.addActionListener(this.autoLengthListener_);
            String lengthStr = this.column.getLength() != null ? this.column.getLength().toString() : "";
            this.txtLength_.setText(lengthStr);
            String scaleStr = this.column.getScale() != null ? this.column.getScale().toString() : "";
            this.txtScale_.setText(scaleStr);
            this.chkUnsigned_.setSelected(!this.column.getSignedFlag());
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.txtLength_.setText("");
        this.txtScale_.setText("");
        this.chkUnsigned_.setSelected(false);
    }

    public boolean getUnsignedUsed() {
        IDataType dataType = this.getDataType();
        boolean used = dataType != null && dataType.isNumberLikeType();
        return used;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getDataType();
    }

    @Override
    public Collector getCollector() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Edit Data Type";
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(0, 0, 340, 235);
    }
}

