/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.lic;

import com.harrand.coreclasses.auth.lic.License;
import com.harrand.coreclasses.auth.lic.PurchaseOption;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.SysUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class PurchaseLinksPanel
extends JPanel {
    private JButton btnPurchaseLink = new JButton("");
    private JButton btnClose = GuiHelper.getCloseBtn();
    private boolean showCloseBtn = false;
    private JLabel lblOpening_ = new JLabel("");
    private JLabel lblThanks = new JLabel("Thank you for supporting DbWrench!");
    private RootPaneContainer parentContainer_;

    PurchaseLinksPanel() {
        this.init();
        this.refresh();
    }

    void setParentContainer(RootPaneContainer parentContainer) {
        this.parentContainer_ = parentContainer;
        this.parentContainer_.getRootPane().setDefaultButton(this.btnPurchaseLink);
    }

    final void refresh() {
        this.removeAll();
        this.layoutComponents();
        this.refreshBtns();
    }

    void setShowCloseBtn(boolean showCloseBtn) {
        this.showCloseBtn = showCloseBtn;
        this.refresh();
    }

    private void init() {
        this.setupGui();
        this.buildListeners();
    }

    private void refreshBtns() {
        if (this.hasPurchaseOption()) {
            this.btnPurchaseLink.setText(this.getPurchaseOption().getButtonText());
        }
    }

    private boolean hasPurchaseOption() {
        return this.getPurchaseOption() != null;
    }

    private PurchaseOption getPurchaseOption() {
        return License.getIntance().getLicenseType().getPurchaseOption();
    }

    private void openURL() {
        String urlStr = this.getPurchaseOption().getURL();
        this.lblOpening_.setText("Opening Web Page: " + urlStr + " ...");
        this.openWebPage();
    }

    private void openWebPage() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        SysUtil.openPurchasePage(PurchaseLinksPanel.this.getPurchaseOption().getURL());
                        PurchaseLinksPanel.this.lblOpening_.setText("");
                    }
                    catch (Exception e) {
                        PurchaseLinksPanel.this.showBrowserFailedMsg();
                        PurchaseLinksPanel.this.lblOpening_.setText("");
                    }
                }
            });
        }
        catch (Exception e) {
            this.showBrowserFailedMsg();
        }
    }

    private void showBrowserFailedMsg() {
        GuiMessageHelper.showWarningMsg(null, "Web Browser Launch", "Could not open the web browser on this system." + System.getProperty("line.separator") + "Please visit: www.dbwrench.com for purchase information.");
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        if (this.hasPurchaseOption()) {
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createGlue());
            this.add(this.btnPurchaseLink);
            GuiHelper.addMedBorder(this);
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)this.lblThanks, "Center");
            GuiHelper.addMedBorder(this);
        }
        if (this.showCloseBtn) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.btnClose);
        }
    }

    private void setCosmetics() {
        Font oldFont = this.lblThanks.getFont();
        this.lblThanks.setForeground(Colors.getGreenComment());
        this.lblThanks.setHorizontalAlignment(0);
        this.lblThanks.setFont(new Font(oldFont.getName(), oldFont.getStyle(), 14));
    }

    private void buildListeners() {
        this.btnPurchaseLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PurchaseLinksPanel.this.openURL();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (PurchaseLinksPanel.this.parentContainer_ != null) {
                    GuiHelper.closeParent(PurchaseLinksPanel.this.parentContainer_);
                }
            }
        });
    }
}

