/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.help;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.security.Code;
import com.harrand.coreclasses.security.ICodeMgr;
import com.harrand.coreclasses.security.ICodeStore;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class AboutPanel
extends JPanel
implements ISized,
ITitled {
    private ICodeStore codeStore_;
    private ICodeMgr codeMgr_;
    private String appVersionStr_;
    private boolean addBorder_;
    private boolean hasLicenseInfo_ = false;
    private JLabel lblVersion_ = new JLabel("(unset)");
    private JLabel lblLicense_ = new JLabel("(unset)");
    private Font defFont_;
    private Font boldFont_;
    private Font plainFont_;
    private int gap_ = 5;
    public static final String TITLE = ResMgr.getRes("about.label");

    public AboutPanel(ICodeMgr codeMgr, ICodeStore codeStore, String appVersionStr, boolean addBorder) {
        this.codeMgr_ = codeMgr;
        this.codeStore_ = codeStore;
        this.appVersionStr_ = appVersionStr;
        this.addBorder_ = addBorder;
        this.hasLicenseInfo_ = this.codeMgr_ != null && this.codeStore_ != null;
        this.buildPanel();
        this.setCosmetics();
        this.refresh();
    }

    private void refresh() {
        this.setTexts();
    }

    private void setTexts() {
        String versionStr = FileHelper.getRes("version.label") + ": " + this.appVersionStr_;
        this.lblVersion_.setText(versionStr);
        if (this.hasLicenseInfo_) {
            Code code = this.codeStore_.getCode();
            int validateId = this.codeMgr_.getValidateId(code);
            String licenseStr = this.codeMgr_.getValidateDesc(code, validateId);
            this.lblLicense_.setText(licenseStr);
        }
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTopPanel(), "Center");
    }

    private JPanel getTopPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("Center", this.getImagePanel());
        panel.add("South", this.getTextPanel());
        return panel;
    }

    private JPanel getImagePanel() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        panel.add(this.getImageLabel());
        return panel;
    }

    private JPanel getTextPanel() {
        JPanel panel = new JPanel();
        JLabel lblDbDesign = new JLabel("Database Design &");
        JLabel lblSync = new JLabel("Synchronization Software");
        JLabel lblWww = new JLabel("www.dbwrench.com");
        JLabel lblCopyright = new JLabel("\u00a9 2002-2008  Nizana Systems");
        this.initFonts(lblDbDesign);
        lblDbDesign.setHorizontalAlignment(0);
        lblSync.setHorizontalAlignment(0);
        this.setLabelA(lblDbDesign);
        this.setLabelA(lblSync);
        this.setLabelB(this.lblVersion_);
        this.setLabelB(this.lblLicense_);
        this.setLabelB(lblWww);
        this.setLabelB(lblCopyright);
        int lblCount = 6;
        if (this.hasLicenseInfo_) {
            ++lblCount;
        }
        panel.setLayout(new GridLayout(lblCount, 1, 0, 0));
        panel.add(lblDbDesign);
        panel.add(lblSync);
        panel.add(new JLabel());
        panel.add(this.lblVersion_);
        if (this.hasLicenseInfo_) {
            panel.add(this.lblLicense_);
        }
        panel.add(lblWww);
        panel.add(lblCopyright);
        panel.setBackground(Color.WHITE);
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JLabel getImageLabel() {
        JLabel lblImage = new JLabel(Icons.SPLASH);
        lblImage.setVerticalTextPosition(3);
        return lblImage;
    }

    private void setLabelA(JLabel lbl) {
        lbl.setOpaque(true);
        lbl.setBackground(Color.WHITE);
        lbl.setForeground(Colors.getBlueKeyword());
        lbl.setFont(this.boldFont_);
    }

    private void setLabelB(JLabel lbl) {
        lbl.setOpaque(true);
        lbl.setBackground(Color.WHITE);
        lbl.setForeground(Color.GRAY);
        lbl.setFont(this.plainFont_);
    }

    private void initFonts(JLabel lbl) {
        this.defFont_ = lbl.getFont();
        String family = "Tahoma";
        this.plainFont_ = new Font(family, 0, 11);
        this.boldFont_ = new Font(family, 1, 11);
    }

    private void setCosmetics() {
        this.setBackground(Color.WHITE);
        if (this.addBorder_) {
            Border raisedbevel = BorderFactory.createRaisedBevelBorder();
            Border loweredbevel = BorderFactory.createLoweredBevelBorder();
            CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
            this.setBorder(compound);
        }
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(360, 245);
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle bounds = this.getPreferredBounds();
        return new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.QUESTION_DLG;
    }
}

